<?php
/**
 * Copyright 2001-2003 by Gero Kohnert
 *
 * Create all tables indices etc for TUTOS
 *
 * !! Remove/Disable this script after running !!
 *
 * @modulegroup ADMIN
 * @module scheme
 * @package BASE
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'timetrack.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'bug.pinc';
 include_once 'mail.pinc';
 include_once 'history.pinc';

 loadmodules("scheme","install");
 loadlayout();

 /**
  * initialize database
  */
 class admin_scheme extends layout {
   /**
    * Perform Step 1  (creating tables,indizes,sequences)
    */
   Function step1() {
     global $table,$tableidx,$sequence;

     echo "<p>";
     echo "<p>";
     echo "Trying to open this Database !<br>\n";
     echo "(you have to create the database or change config.pinc if this test failed !<br>\n";
     flush();
     $out = 0;
     if ( $this->obj->conn != -1 ) {
       echo "&nbsp; Looks OK <i>(". $this->obj->gettype() ." -> ". $this->obj->conn .")</i> !<br>\n";
     } else {
       echo "failed to open Database <br>";
       flush();
       return;
     }
     echo "<p>";
     flush();

     foreach ($table as $i => $f) {
       echo $f[Desc] ."<br>\n";
       if ($this->obj->droptable($f) == -1) {
         echo "Table <b>". $this->obj->prefix . $f[name] ."</b> not dropped:<span class=\"warn\">". $this->obj->lasterror ."</span><br>\n";
       } else { 
         echo "<span class=\"found\">Table <b>". $this->obj->prefix . $f[name] ."</b> dropped</span><br>\n";
       } 
       if ($this->obj->createtable($f) == -1) {
         echo "Table not created:<span class=\"warn\">". $this->obj->lasterror ."</span><br>\n";
       } else { 
         echo "<span class=\"found\">Table <b>". $this->obj->prefix . $f[name] ."</b> created</span><br>\n";
       }
	   flush();
     }
     # Build the inidces
     echo "<p>\n";
     foreach ($tableidx as $i => $f) {
       echo $f[Desc] ."<br>\n";
       if ($this->obj->dropindex($f) == -1) {
#       echo "Index not dropped:<span class=\"warn\">". $this->obj->lasterror ."</span><br>\n";
       } else { 
         echo "<span class=\"found\">Index dropped</span><br>\n";
       }
       if ($this->obj->createindex($f) == -1) {
        echo "Index <b>". $this->obj->prefix . $f[name] ."</b> not created:<span class=\"warn\">". $this->obj->lasterror ."</span><br>\n";
       } else { 
         echo "<span class=\"found\">Index <b>". $this->obj->prefix . $f[name] ."</b> created</span><br>\n";
       }
	   flush();
     }
     # Build the sequencers
     echo "<p>\n";
     @reset($sequence);
     while ( list ($i,$f) = @each ($sequence) ) {
       echo $f[Desc] ."<br>\n";
       if ( $this->obj->dropsequence($f) == -1 ) {
         echo "Sequence ". $this->obj->prefix . $f[name] ." not dropped:<span class=\"warn\">". $this->obj->lasterror ."</span><br>\n";
       } else {
         echo "<span class=\"found\">Sequence ". $this->obj->prefix . $f[name] ." dropped</span><br>\n";
       };
       if ( $this->obj->createsequence($f) == -1 ) {
         echo "Sequence ". $this->obj->prefix . $f[name] ." not created:<span class=\"warn\">". $this->obj->lasterror ."</span><br>\n";
       } else {
         echo "<span class=\"found\">Sequence ". $this->obj->prefix . $f[name] ." created</span><br>\n";
       };
       flush();
     }
     # Save the Database
     # The current DB entry is always that with the ID 1
     $this->obj->db->creator = $this->user;
     $this->obj->db->newid = 1;
     $this->obj->db->id = -1;
     $this->obj->db->dbconn = &$this->obj;
     $msg = $this->obj->db->save();
     echo $msg;
     return;
   }
   /**
    * Perform Step 2  (insert a single super user)
    */
   Function step2() {
     global $tutos;

     $msg = "";
     echo "Creating a <b>superuser</b> account<br>\n";
     $tutos[demo] = 0;

     $adr = new tutos_address($this->obj);
     $adr->f_name = "Super";
     $adr->l_name = "User";
     $adr->birthday = new DateTime();
     $adr->creator = $adr;
     $msg .= $adr->save();

     $this->user = new tutos_user($this->obj);
     $this->user->updatepw = 1;
     $this->user->login = "superuser";
     $this->user->pw = "tutos";
     $this->user->id = $adr->id;
     $this->user->admin = 1;

     $msg = $this->user->save();
     echo $msg ."<br>\n";
   }
   /**
    * Perform Step 3  (example data)
    */
   Function step3() {
     global $lang,$tutos,$current_user;

     echo "Creating some demo data<br>\n";
     flush();
     $msg = "";
     # No mails here !!
     $tutos[demo] = 0;

     $u1 = new tutos_user($this->obj);
     $u2 = new tutos_user($this->obj);
     $u3 = new tutos_user($this->obj);
     $a1 = new tutos_address($this->obj);
     $a2 = new tutos_address($this->obj);
     $a3 = new tutos_address($this->obj);

     # User & Addresses
     $a1->f_name = "Linus";
     $a1->m_name = "B";
     $a1->l_name = "Torvalds";
     $a1->creator = &$this->user;
     $msg .= $a1->save();
     echo $lang[$a1->getType()].":". $a1->getFullName() ."<br>\n";
     flush();

     $u1->updatepw = 1;
     $u1->login = "linus";
     $u1->pw = "guest";
     $u1->id = $a1->id;
     $msg .= $u1->save();
     echo $lang[$u1->getType()].":". $u1->login ."<br>\n";
     flush();

	 $current_user = &$u1;

     $a2->f_name = "Bill";
     $a2->l_name = "Gates";
     $a2->creator = &$u1;
     $msg .= $a2->save();
     echo $lang[$a2->getType()].":". $a2->getFullName() ."<br>\n";
     flush();

     $u2->updatepw = 1;
     $u2->login = "billgates";
     $u2->pw = "guest";
     $u2->id = $a2->id;
     $msg .= $u2->save();
     echo $lang[$u2->getType()].":". $u2->login ."<br>\n";
     flush();

     $a3->f_name = "Gero";
     $a3->l_name = "Kohnert";
     $a3->creator = &$u1;
     $msg .= $a3->save();
     echo $lang[$a3->getType()].":". $a3->getFullName() ."<br>\n";
     flush();

     $u3->updatepw = 1;
     $u3->login = "gero";
     $u3->pw = "guest";
     $u3->id = $a3->id;
     $msg .= $u3->save();
     echo $lang[$u3->getType()].":". $u3->login ."<br>\n";
     flush();

     # Team
     $x1 = new team($this->obj);
     $add = array();
     $del = array();
     $add[0] = $a1->id;
     $add[0] = $a3->id;
     $x1->name = "TUTOS Development";
     $x1->owner = $a3;
     $x1->creator = $u3;
     $msg .= $x1->save($add,$del);
     echo $lang[$x1->getType()].":". $x1->getFullName() ."<br>\n";
     flush();

     $x2 = new team($this->obj);
     $add = array();
     $del = array();
     $add[0] = $a2->id;
     $x2->name = "The Others";
     $x2->creator = $u3;
     $x2->owner = $a3;
     $msg .= $x2->save($add,$del);
     echo $lang[$x2->getType()].":". $x2->getFullName() ."<br>\n";
     flush();

     # Companies
     $f1 = new company($this->obj);
     $f1->name = "Linux Consulting";
     $msg .= $f1->save();
     echo $lang[$f1->getType()].":". $f1->getFullName() ."<br>\n";

     $f2 = new company($this->obj);
     $f2->name = "S.u.S.E";
     $msg .= $f2->save();
     echo $lang[$f2->getType()].":". $f2->getFullName() ."<br>\n";

     # Departments
     $d1 = new department($this->obj);
     $d1->name = "Sales";
     $d1->company = &$f1;
     $msg .= $d1->save();
     echo $lang[$d1->getType()].":". $d1->getFullName() ."<br>\n";

     $d2 = new department($this->obj);
     $d2->name = "Sales";
     $d2->company = &$f2;
     $msg .= $d2->save();
     echo $lang[$d2->getType()].":". $d2->getFullName() ."<br>\n";

     # Locations
     $l1 = new location($this->obj);
     $l1->company = &$f1;
     $l1->lname = "Home";
     $l1->city = "Erlangen";
     $l1->zip  = "91058";
     $l1->country  = "DE";
     $l1->adr_id  = $a3->id;
     $msg .= $l1->save();
     echo $lang[$l1->getType()].":". $l1->lname ."<br>\n";
     flush();
   
     $l2 = new location($this->obj);
     $l2->company = &$f1;
     $l2->lname = "Headquarter";
     $l2->city = "Erlangen";
     $l2->zip  = "91058";
     $l2->country  = "DE";
     $l2->adr_id  = $f1->id;
     $msg .= $l2->save();
     echo $lang[$l2->getType()].":". $l2->lname ."<br>\n";
     flush();
   

#   $dbconn->Close();
#   $dbconn->Open();

     # No mails here !!
     $tutos[demo] = 1;

     # Products
     $p1 = new product($this->obj);
     $p1->name = "TUTOS";
     $p1->version = $tutos[version];
     $p1->creator = &$u3;
	 $p1->setRole($a3,PROD_ROLE_MANAGER,"managing");
	 $p1->setRole($f1,PROD_ROLE_PARTNER,"find the customers");
     $p1->cl[1][] = 1;
     $p1->cl[2][] = 1;
     $msg .= $p1->save();
     echo $lang[$p1->getType()].":". $p1->getFullName() ."<br>\n";

     $p2 = new product($this->obj);
     $p2->name = "Linux";
     $p2->version = "2.2";
     $p2->creator = &$u1;
	 $p1->setRole($a1,PROD_ROLE_MANAGER,"lead the bunch");
     $p2->cl[1][] = 1;
     $p2->cl[2][] = 1;
     $msg .= $p2->save();
     echo $lang[$p2->getType()].":". $p2->getFullName() ."<br>\n";

     $p3 = new product($this->obj);
     $p3->name = "Linux";
     $p3->version = "2.4";
     $p3->creator = &$u1;
	 $p1->setRole($a1,PROD_ROLE_MANAGER,"lead the bunch");
	 $p1->setRole($p2,PROD_ROLE_ANCESTOR,"");
     $msg .= $p3->save();
     echo $lang[$p3->getType()].":". $p3->getFullName() ."<br>\n";

     # Appointment
     $c1 = new appointment($this->obj);
     $c1->creator = &$u1;
     $c1->mod_allow = 0;
     $c1->descr = "Meeting";
     $c1->outside = 1;
     $c1->t_ignore = 1;
     $c1->a_start = new DateTime();
     $c1->a_end   = new DateTime();
     $c1->visitor = &$a2;
     $c1->product = &$p1;
     $c1->participant[$a1->id] = &$a1;
     $c1->participant[$a3->id] = &$a3;
     $msg .= $c1->save();
     echo $lang[$c1->getType()].":". $c1->getFullName() ."<br>\n";

     $c2 = new appointment($this->obj);
     $c2->creator = &$u1;
     $c2->mod_allow = 0;
     $c2->descr = "Count my money";
     $c2->t_ignore = 1;
     $c2->outside = 0;
     $c2->a_start = new DateTime();
     $c2->a_end   = new DateTime();
     $c2->a_end->addDays(2);
     $c2->participant[$a2->id] = &$a2;
     $msg .= $c2->save();
     echo $lang[$c2->getType()].":". $c2->getFullName() ."<br>\n";

     # Bug
     $b1 = new bug($this->obj);
	 $b1->setName("auto");
     $b1->state = 1;
     $b1->class = 1;
     $b1->short = "too slow";
     $b1->description = "too slow";
     $b1->parent = $p2;
     $b1->creator = $u1;
     $b1->solver = $a1;
     $msg .= $b1->save();
     echo $lang[$b1->getType()].":". $b1->getFullName() ."<br>\n";

     $b2 = new bug($this->obj);
	 $b2->setName("auto");
     $b2->state = 1;
     $b2->class = 1;
     $b2->short = "too fast";
     $b2->description = "too fast";
     $b2->parent = &$p1;
     $b2->creator = $u2;
     $b2->solver = $a2;
     $msg .= $b2->save();
     echo $lang[$b2->getType()].":". $b2->getFullName() ."<br>\n";

     # Task
     $t1 = new task($this->obj);
     $t1->name = "Demo Task 1";
     $t1->description = "This is a task";
	 $x = new DateTime();
     $t1->setSStart($x);
	 $x->addDays(3);
     $t1->setSEnd($x);
     $t1->volume = 12.5;
     $t1->state = 1;
     $t1->p_id = $p1->id;
     $t1->worker[$a1->id] = $a1;
     $msg .= $t1->save();
     echo $lang[$t1->getType()].":". $t1->getFullName() ."<br>\n";

     $t2 = new task($this->obj);
     $t2->name = "Demo Task 2";
     $t2->description = "This is another task";
     $t2->volume = 2.5;
     $t2->state = 0;
     $t2->p_id = $p1->id;
     $t2->worker[$a1->id] = $a1;
	 $x = new DateTime();
	 $x->addDays(1);
     $t2->setSStart($x);
	 $x->addDays(2);
     $t2->setSEnd($x);
     $msg .= $t2->save();
     echo $lang[$t2->getType()].":". $t2->getFullName() ."<br>\n";

     $t3 = new task($this->obj);
     $t3->name = "Demo Task 3";
     $t3->description = "a lot to do eh ?";
     $t3->volume = 14.5;
     $t3->state = 2;
     $t3->p_id = $t2->id;
     $t3->worker[$a1->id] = $a1;
     $t3->worker[$a2->id] = $a2;
	 $x = new DateTime();
	 $x->addDays(2);
     $t3->setSStart($x);
	 $x->addDays(2);
     $t3->setSEnd($x);
     $msg .= $t3->save();
     echo $lang[$t3->getType()].":". $t3->getFullName() ."<br>\n";

     # Timetrack
     $tt1 = new timetrack($this->obj);
     $tt1->link_id = $t1->id;
     $tt1->ref = &$t1;
     $tt1->worker = &$a1;
     $tt1->volume = 2.1;
     $tt1->desc = "Working on demo task";
     $tt1->wday = new DateTime();
     $tt1->state = 1;
     $tt1->invoice = -1;
     $tt1->cph = 110.5;
     $tt1->currency = "EUR";
     $tt1->creator = $u2;
     $msg .= $tt1->save();
     echo $lang[$tt1->getType()].":". $tt1->getFullName() ."<br>\n";

     # Resources
     if ( class_exists ("resource") ) {
       $r1 = new resource($this->obj);
       $r1->name = "Meeting Room";
       $r1->desc = "The big Meeting Room first floor";
       $r1->creator = &$u1;
       $msg .= $r1->save();
       echo $lang[$r1->getType()].":". $r1->getFullName() ."<br>\n";
     }
     # Notes
     if ( class_exists ("note") ) {
       $n1 = new note($this->obj);
       $n1->creator = $u1;
       $n1->name = "Remember this !";
       $n1->note = "Remember to look at TUTOS";
       $n1->link_id = $p1->id;
       $n1->ref = &$p1;
       $msg .= $n1->save();
       echo $lang[$n1->getType()].":". $n1->getFullName() ."<br>\n";
       if ( class_exists ("resource") ) {
         $n2 = new note($this->obj);
         $n2->creator = $u2;
         $n2->name = "repair";
         $n2->note = "Repair the desk in the meeting room";
         $n2->link_id = $r1->id;
         $n2->ref = &$r1;
         $msg .= $n2->save();
         echo $lang[$n2->getType()].":". $n2->getFullName() ."<br>\n";
       }
     }
     if ( class_exists ("url") ) {
       $url1 = new url($this->obj);
       $url1->name = "homepage";
       $url1->url = "http://www.tutos.org";
       $url1->link_id = $p1->id;
       $url1->creator = $u2;
       $msg .= $url1->save();
       echo $lang[$url1->getType()].":". $url1->getFullName() ."<br>\n";

       $url2 = new url($this->obj);
       $url2->creator = $u2;
       $url2->name = "homepage";
       $url2->url = "http://www.tutos.org";
       $url2->link_id = $f1->id;
       $msg .= $url2->save();
       echo $lang[$url2->getType()].":". $url2->getFullName() ."<br>\n";
	 }
     echo $msg ."<br>\n";
     return;
   }
   /**
    * intialize a database step by step
    */
   Function info() {
     global $tutos,$lang;

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">". $lang['AdminDBInfo'] ."</th>\n";
     echo "</tr>\n";
     echo "<tr>\n";
     echo $this->showfield("Database Type");
     echo $this->showdata($this->obj->GetType(),3);
     echo "</tr>\n";
     echo "<tr>\n";
     echo $this->showfield($lang['AdminDBInfo']);
     echo $this->showdata($this->obj->moreinfo(),3);
     echo "</tr>\n";
     echo "<tr>\n";
     echo $this->showfield($lang['AdminDBName']);
     echo $this->showdata($this->obj->db->name ."  ". $this->obj->prefix,1);
     echo $this->showfield($lang['AdminDBUser']);
     echo $this->showdata($this->obj->db->user);
     echo "</tr>\n";
     echo "<tr>\n";
     echo $this->showfield($lang['AdminDBHost']);
     echo $this->showdata($this->obj->db->host);
     echo $this->showfield($lang['AdminDBPort']);
     echo $this->showdata($this->obj->db->port);
     echo "</tr>\n";
     echo $this->DataTableEnd();
     flush();

     echo "<p><b>This is initialization STEP ". $this->step ."</b><br>\n";

     echo "<form name=\"init\" action=\"scheme.php\" method=\"get\">\n";
     $this->addHidden("id",$this->id);
     if ( $this->step == 0 ) {
       echo "Is the above info correct ?<br>\n";
       echo "(otherwise correct <i>config.[pinc|php]</i> an come back)<br>\n";
       echo "Go on to create the database layout<br>\n";
       echo "All existing data will be removed<br>\n";
     }
     if ( $this->step == 1 ) {
       $this->step1();
       echo "Go on to create a superuser account<br>\n";
     }
     if ( $this->step == 2 ) {
       $this->step2();
       echo "Go on to create some example data<br>\n";
     }
     if ( $this->step == 3 ) {
       $this->step3();
     }
     if ( $this->step == 4 ) {
       echo "<span class=\"warn\">If everything works disable this script</span><br>\n";
       echo "Come on and login<br>\n";
     } else {
       $this->step++;
       $this->addHidden("step",$this->step);
       echo "<input type=\"submit\" value=\"". $lang['Enter'] . " Step ". $this->step ."\">";
     }
     echo $this->getHidden();
     echo "</form>\n";
     $this->obj->Close();
   }
   /**
    * navigate
    */
   Function navigate() {
     global $tutos,$lang;

     echo "<tr><td nowrap>";
     echo menulink("update.php?id=".$this->id ,"UPDATE ". $tutos[dbalias][$this->id]);
     echo "<br>\n";
     echo "<br>\n";

     @reset ($tutos[dbname]);
     while ( list ($i,$f) = @each ($tutos[dbname]) ) {
       echo menulink("scheme.php?id=".$i ,$tutos[dbalias][$i],$tutos[dbalias][$i]);
	   echo "<br>\n";
     }

     echo "<br>\n";
     echo "</td></tr>";
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$current_user,$lang,$tutos,$msg,$table,$tableidx,$sequence;

	 if (isset($_GET['msg'])) { 
       $msg = $_GET['msg'];
	 }
     ReadLang($lang);

     if ( ! minimum_version(minimumversion) ) {
       $msg .= "<br>\nSorry TUTOS needs a PHP Version >=  ". minimumversion ."<br>\n";
       $msg .= "you are using ". phpversion() ."<br>\n";
       $this->stop = true;
     }

     # read the table definitions of modules
     foreach ($tutos[modules] as $r => $x) {
       if (file_exists(dirname($tutos['base'] ."/". $tutos[modules][$r][file]) ."/mtable.pinc") ) {
         @include_once dirname($tutos['base'] ."/". $tutos[modules][$r][file]) ."/mtable.pinc";
		 loadmodule($r);
       }
     }
     if ( isset($_GET['step']) && ($tutos[demo] == 0) ) {
       $this->step = $_GET['step'];
     } else {
       $this->step = 0;
     }
     if ( isset($_GET['id']) ) {
       $this->id = $_GET['id'];
     } else {
       $this->id = 0;
       $msg .= "Using default Database ID 0  (see config.pinc)";
     }
     if ( ! isset($tutos[dbname][$this->id] ) ) {
       $msg .= "<br>The given database id ". $this->id ." is not defined in you configuration";
       $this->stop = true;
     } else {
       $this->obj = DB_Open($this->id,false);
	 }
     if ( $this->stop == false ) {
       if ( $this->obj->gettype() == "Postgres" ) {
         # No persistent connections here
         $this->obj->setPersistent(0);
       }
       if ( $this->obj->gettype() == "Interbase" ) {
         # No persistent connections here
         $this->obj->setPersistent(0);
       }
     }
     $this->user = new tutos_user($this->obj);
     $this->user->f_name = "TUTOS";
     $this->user->l_name = "(installation service)";
     $this->user->admin = 1;
	 $current_user = $this->user;

     $this->name = $lang['DBInit']." STEP ". $this->step;
   }
 }


 $dbc = null;
 $x = new tutos_user($dbc);
 $l = new admin_scheme($x);
 $l->display();
?>
<!--
    CVS Info:  $Id: scheme.php,v 1.51.2.1 2003/05/09 16:20:53 gokohnert Exp $
    $Author: gokohnert $
-->
