<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup company
 * @module company_ins
 * @package company
 */
 include_once "webelements.p3";
 include_once "permission.p3";

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('company','ins');

 $gotourl = "company_new.php";
 $msg = "";
 $c = new company($dbconn);

 if ( !isset($_POST['id']) ) {
   $msg .= "Please enter a id<br>";
 } else {
   $c->read($_POST['id']);
   if ( $c->id > 0 ) {
     $gotourl = addUrlParameter($gotourl,"id=". $c->id);
   }
 }

 if ( !isset($_POST['name']) || ($_POST['name'] == $lang['PlsChangeName']) || empty($_POST['name']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['Company']) ."<br>";
 } else {
   $name = trim(StripSlashes($_POST['name']));
   $gotourl = addUrlParameter($gotourl,"name=". UrlEncode($name));
 }

 if ( $msg == "" ) {
   if ( ($c->id < 0) || ($name != $c->name) ) {
     $q = "SELECT * FROM ". $c->tablename ." WHERE ". $dbconn->Like2("name", $name);
     $r = $dbconn->Exec($q);
     $n = $r->numrows();
     if ( 0 != $n) {
       $x = new company($dbconn);
       $x->read_result($r,0);
       $msg .= sprintf($lang['Err0044'],$x->getLink()) ."<br>";
     }
     $r->free();
   }
 }

 # other modules
 $msg .= module_parseforms($current_user,$c,$gotourl);

 if ( $msg == "" ) {
   $c->setName($name);

   $dbconn->Begin("WORK");
   $msg = $c->save();
   $dbconn->Commit("WORK");

   $gotourl = $c->getURL();
 }

 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));
 $gotourl = addSessionKey($gotourl);

 /* Go back to user mask */
 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl );
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: company_ins.php,v 1.22.2.2 2003/06/18 14:34:32 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
