// Written in 2000 by Peter Karlsson
//
// $Id: mytime.h,v 1.2 2000/12/04 21:09:53 peterk Exp $
//
// This file is not copyrighted.

#ifndef __MYTIME_H
#define __MYTIME_H

/**
 * Convert a tm structure to time_t, disregarding timezone.
 * This function behaves just like the standard C library function mktime,
 * except that it does not do adjustments for the local timezone when
 * converting. This is needed since most Fidonet message base formats assume
 * that the date stored in the messages are in local time, and we can thus
 * not do any reliable timezone adjustments on the values we receive.
 */
time_t my_mktime(struct tm *);

#endif
