/*
 * Decompiled with CFR 0.152.
 */
package jargs.gnu;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class CmdLineParser {
    private String[] remainingArgs = null;
    private Hashtable options = new Hashtable(10);
    private Hashtable values = new Hashtable(10);

    public final Option addOption(Option opt) {
        if (opt.shortForm() != null) {
            this.options.put("-" + opt.shortForm(), opt);
        }
        this.options.put("--" + opt.longForm(), opt);
        return opt;
    }

    public final Option addStringOption(char shortForm, String longForm) {
        return this.addOption(new Option.StringOption(shortForm, longForm));
    }

    public final Option addStringOption(String longForm) {
        return this.addOption(new Option.StringOption(longForm));
    }

    public final Option addIntegerOption(char shortForm, String longForm) {
        return this.addOption(new Option.IntegerOption(shortForm, longForm));
    }

    public final Option addIntegerOption(String longForm) {
        return this.addOption(new Option.IntegerOption(longForm));
    }

    public final Option addLongOption(char shortForm, String longForm) {
        return this.addOption(new Option.LongOption(shortForm, longForm));
    }

    public final Option addLongOption(String longForm) {
        return this.addOption(new Option.LongOption(longForm));
    }

    public final Option addDoubleOption(char shortForm, String longForm) {
        return this.addOption(new Option.DoubleOption(shortForm, longForm));
    }

    public final Option addDoubleOption(String longForm) {
        return this.addOption(new Option.DoubleOption(longForm));
    }

    public final Option addBooleanOption(char shortForm, String longForm) {
        return this.addOption(new Option.BooleanOption(shortForm, longForm));
    }

    public final Option addBooleanOption(String longForm) {
        return this.addOption(new Option.BooleanOption(longForm));
    }

    public final Object getOptionValue(Option o) {
        return this.values.get(o.longForm());
    }

    public final String[] getRemainingArgs() {
        return this.remainingArgs;
    }

    public final void parse(String[] argv) throws IllegalOptionValueException, UnknownOptionException {
        this.parse(argv, Locale.getDefault());
    }

    public final void parse(String[] argv, Locale locale) throws IllegalOptionValueException, UnknownOptionException {
        String curArg;
        int position;
        Vector<String> otherArgs = new Vector<String>();
        this.values = new Hashtable(10);
        for (position = 0; position < argv.length && (curArg = argv[position]).startsWith("-"); ++position) {
            Option opt;
            int equalsPos;
            if (curArg.equals("--")) {
                ++position;
                break;
            }
            String valueArg = null;
            if (curArg.startsWith("--") && (equalsPos = curArg.indexOf("=")) != -1) {
                valueArg = curArg.substring(equalsPos + 1);
                curArg = curArg.substring(0, equalsPos);
            }
            if ((opt = (Option)this.options.get(curArg)) == null) {
                throw new UnknownOptionException(curArg);
            }
            Object value = null;
            if (opt.wantsValue()) {
                if (valueArg == null) {
                    valueArg = null;
                    if (++position < argv.length) {
                        valueArg = argv[position];
                    }
                }
                value = opt.getValue(valueArg, locale);
            } else {
                value = opt.getValue(null, locale);
            }
            this.values.put(opt.longForm(), value);
        }
        while (position < argv.length) {
            otherArgs.addElement(argv[position]);
            ++position;
        }
        this.remainingArgs = new String[otherArgs.size()];
        int i = 0;
        Enumeration e = otherArgs.elements();
        while (e.hasMoreElements()) {
            this.remainingArgs[i] = (String)e.nextElement();
            ++i;
        }
    }

    public static abstract class Option {
        private String shortForm = null;
        private String longForm = null;
        private boolean wantsValue = false;

        protected Option(String longForm, boolean wantsValue) {
            this(null, longForm, wantsValue);
        }

        protected Option(char shortForm, String longForm, boolean wantsValue) {
            this(new String(new char[]{shortForm}), longForm, wantsValue);
        }

        private Option(String shortForm, String longForm, boolean wantsValue) {
            if (longForm == null) {
                throw new IllegalArgumentException("null arg forms not allowed");
            }
            this.shortForm = shortForm;
            this.longForm = longForm;
            this.wantsValue = wantsValue;
        }

        public String shortForm() {
            return this.shortForm;
        }

        public String longForm() {
            return this.longForm;
        }

        public boolean wantsValue() {
            return this.wantsValue;
        }

        public final Object getValue(String arg, Locale locale) throws IllegalOptionValueException {
            if (this.wantsValue) {
                if (arg == null) {
                    throw new IllegalOptionValueException(this, "");
                }
                return this.parseValue(arg, locale);
            }
            return Boolean.TRUE;
        }

        protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
            return null;
        }

        public static class StringOption
        extends Option {
            public StringOption(char shortForm, String longForm) {
                super(shortForm, longForm, true);
            }

            public StringOption(String longForm) {
                super(longForm, true);
            }

            protected Object parseValue(String arg, Locale locale) {
                return arg;
            }
        }

        public static class DoubleOption
        extends Option {
            public DoubleOption(char shortForm, String longForm) {
                super(shortForm, longForm, true);
            }

            public DoubleOption(String longForm) {
                super(longForm, true);
            }

            protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
                try {
                    NumberFormat format = NumberFormat.getNumberInstance(locale);
                    Number num = format.parse(arg);
                    return new Double(num.doubleValue());
                }
                catch (ParseException e) {
                    throw new IllegalOptionValueException(this, arg);
                }
            }
        }

        public static class LongOption
        extends Option {
            public LongOption(char shortForm, String longForm) {
                super(shortForm, longForm, true);
            }

            public LongOption(String longForm) {
                super(longForm, true);
            }

            protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
                try {
                    return new Long(arg);
                }
                catch (NumberFormatException e) {
                    throw new IllegalOptionValueException(this, arg);
                }
            }
        }

        public static class IntegerOption
        extends Option {
            public IntegerOption(char shortForm, String longForm) {
                super(shortForm, longForm, true);
            }

            public IntegerOption(String longForm) {
                super(longForm, true);
            }

            protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
                try {
                    return new Integer(arg);
                }
                catch (NumberFormatException e) {
                    throw new IllegalOptionValueException(this, arg);
                }
            }
        }

        public static class BooleanOption
        extends Option {
            public BooleanOption(char shortForm, String longForm) {
                super(shortForm, longForm, false);
            }

            public BooleanOption(String longForm) {
                super(longForm, false);
            }
        }
    }

    public static class IllegalOptionValueException
    extends OptionException {
        private Option option;
        private String value;

        public IllegalOptionValueException(Option opt, String value) {
            super("illegal value '" + value + "' for option " + (opt.shortForm() != null ? "-" + opt.shortForm() + "/" : "") + "--" + opt.longForm());
            this.option = opt;
            this.value = value;
        }

        public Option getOption() {
            return this.option;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class UnknownOptionException
    extends OptionException {
        private String optionName = null;

        UnknownOptionException(String optionName) {
            super("unknown option '" + optionName + "'");
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }
    }

    public static abstract class OptionException
    extends Exception {
        OptionException(String msg) {
            super(msg);
        }
    }
}

