#Boa:Dialog:StreamInfo
#TunaPie (c)2005-2006 James Stone. Released under the GNU GPL.
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
#Written using Boa-Constructor.
#http://boa-constructor.sourceforge.net/
#
#Version 0.0.3 26/09/06


import wx
import wx.lib.stattext

def create(parent):
    return StreamInfo(parent)

[wxID_STREAMINFO, wxID_STREAMINFOINFOBOX, wxID_STREAMINFOOKBUTTON, 
 wxID_STREAMINFOURLLABEL, 
] = [wx.NewId() for _init_ctrls in range(4)]

class StreamInfo(wx.Dialog):
    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Dialog.__init__(self, id=wxID_STREAMINFO, name=u'StreamInfo',
              parent=prnt, pos=wx.Point(295, 232), size=wx.Size(438, 259),
              style=wx.DEFAULT_DIALOG_STYLE, title=u'Stream Info')
        self.SetClientSize(wx.Size(438, 259))
        self.SetThemeEnabled(True)
        self.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)

        self.urllabel = wx.lib.stattext.GenStaticText(ID=wxID_STREAMINFOURLLABEL,
              label=u'Info:', name=u'urllabel', parent=self, pos=wx.Point(16,
              16), size=wx.Size(21, 15), style=0)
        self.urllabel.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Helvetica'))
        self.urllabel.SetThemeEnabled(True)

        self.okbutton = wx.Button(id=wxID_STREAMINFOOKBUTTON, label=u'OK',
              name=u'okbutton', parent=self, pos=wx.Point(184, 216),
              size=wx.Size(85, 30), style=0)
        self.okbutton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Helvetica'))
        self.okbutton.SetThemeEnabled(True)
        self.okbutton.Bind(wx.EVT_BUTTON, self.OnOkbuttonButton,
              id=wxID_STREAMINFOOKBUTTON)

        self.infobox = wx.ListBox(choices=[], id=wxID_STREAMINFOINFOBOX,
              name=u'infobox', parent=self, pos=wx.Point(56, 16),
              size=wx.Size(352, 184), style=0)
        self.infobox.SetThemeEnabled(True)

    def __init__(self, parent):
        self._init_ctrls(parent)

    def setfontsize(self, newsize):
        size=int(newsize)
        self.urllabel.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.okbutton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
    
    def OnOkbuttonButton(self, event):
        self.Close()
        
    def FillInfo (self, info):
        x=0
        for item in info:
            itemstrip=item.rstrip('\n')
            self.infobox.Append(itemstrip)
    
    
            
