//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef _StrengthClustering_H
#define _StrengthClustering_H

#include <string>
#include <set>
#include <vector>
#include <map>
#include <tulip/TulipPlugin.h>

/** \addtogroup clustering */
/*@{*/
class StrengthClustering:public tlp::Algorithm { 
public:
  StrengthClustering(tlp::AlgorithmContext);
  ~StrengthClustering();
  bool run();
  bool check(std::string &);
private:
  std::vector< std::set<tlp::node> > computeNodePartition(double threshold);
  double computeMQValue(const std::vector< std::set<tlp::node> > & partition, tlp::Graph *);
  double findBestThreshold(int numberOfSteps, bool& stopped);
  tlp::Graph* buildSubGraphs(const std::vector< std::set<tlp::node > > &);
  bool recursiveCall(tlp::Graph *, std::map<tlp::Graph *, tlp::Graph *> &);
  tlp::Graph* buildQuotientGraph(tlp::Graph *);
  void adjustMetaGraphProperty(tlp::Graph *, std::map<tlp::Graph *, tlp::Graph *> &);
  tlp::DoubleProperty* values;
  bool subgraphsLayout;
  bool quotientLayout;
};
/*@}*/
#endif
