//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef Tulip_GLGRAPHSTATICDATA_H
#define Tulip_GLGRAPHSTATICDATA_H

#include <tulip/tulipconf.h>

#include <string>

namespace tlp {

  enum EdgeShape {POLYLINESHAPE = 0, BEZIERSHAPE = 4, SPLINESHAPE = 8};
  
  class TLP_GL_SCOPE GlGraphStaticData {
  
  public:

    static const int edgeShapesCount;
    static int edgeShapeIds[];
    static std::string labelPositionNames[];
    
    static std::string edgeShapeName(int id);
    static int edgeShapeId(std::string name);
  
    static std::string labelPositionName(int id);
    static int labelPositionId(std::string name);
    
  };
  
}

#endif // Tulip_GLGRAPHSTATICDATA_H
