// Warning !!! this file does not have to be compiled
// when building Tulip with Qt 3
#include "tulip/ClusterTreePlugin.h"
#include <QtCore/QtPlugin>
#include "tulip/TlpTools.h"
#include "tulip/ClusterTreeQt3.h"

#include "../designer/clustertree.xpm"

ClusterTreePlugin::ClusterTreePlugin(QObject *parent) : QObject(parent) {
  initialized = false;
  supergraph = tlp::newSuperGraph();
}

ClusterTreePlugin::~ClusterTreePlugin() {
  delete supergraph;
}

void ClusterTreePlugin::initialize(QDesignerFormEditorInterface * /*core*/) {
  if (initialized)
    return;

  initialized = true;
}

bool ClusterTreePlugin::isInitialized() const {
  return initialized;
}

QWidget* ClusterTreePlugin::createWidget(QWidget *parent) {
  return new ClusterTree(supergraph, parent, name());
}

QString ClusterTreePlugin::name() const {
  return "ClusterTree";
}
  
QString ClusterTreePlugin::domXml() const {
  return "<widget class=\"ClusterTree\" name=\"clusterTree\">\n"
         "</widget>\n";
}

QString ClusterTreePlugin::includeFile() const {
  return "tulip/ClusterTree.h";
}

QString ClusterTreePlugin::group() const {
  return "Tulip Widgets";
}

QIcon ClusterTreePlugin::icon() const {
  return QIcon(QPixmap(clustertree_xpm));
}

QString ClusterTreePlugin::toolTip() const {
  return "Cluster Tree";
}

QString ClusterTreePlugin::whatsThis() const {
  return "A widget displaying a tree of all clusters present in a Tulip SuperGraph";
}

bool ClusterTreePlugin::isContainer() const {
  return false;
}

QString ClusterTreePlugin::codeTemplate() const {
    return "";
}

Q_EXPORT_PLUGIN(ClusterTreePlugin)
