//-*-c++-*-
#ifndef Tulip_GLGRAPH_WIDGET_H
#define Tulip_GLGRAPH_WIDGET_H
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 06/09/2005
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tulip/GlADComposite.h>
#include <tulip/SuperGraph.h>
#include <tulip/GlGraph.h>

#if (QT_REL == 3)
#include <qgl.h>
#include <qpoint.h>
#else
#include <QtOpenGL/qgl.h>
#include <QtCore/qpoint.h>
#include "tulip/Qt3ForTulip.h"
#endif

#include "tulip/MouseInterface.h"

//class QTextView;
class QTimer;
class GlGraph;
/** \addtogroup Tulip_Widgets */ 
/*@{*/
class TLP_QT_SIMPLE_SCOPE GlGraphWidget : public QGLWidget, public GlGraph {
  Q_OBJECT;
  
public:
  GlGraphWidget(QWidget *parent=NULL, const char *name=NULL);
  GlGraphWidget(const GlGraphWidget &, QWidget *parent=NULL, const char *name=NULL);
  ~GlGraphWidget();

  //GlGraph *getGlGraph() const; 
  //SuperGraph *getSuperGraph() const;
  MouseInterface *getMouse() const;
  virtual QImage grabFrameBuffer(bool withAlpha = false);

  //  void  initializeGL();
  void  paintGL();
  void  resizeGL(int w, int h);

  ///
  //  void  setQTextView(QTextView *);

  void  makeCurrent();
  void  updateGL();
  void initializeGL();

  bool  timerIsActive();
  int   timerStart(int, bool sshot=false);
  void  timerStop();
  
  void  mPaint();
  //  void  outputSetText(const std::string&);
  //  const std::string outputGetText();
  //  void  update(std::set<Observable *>::iterator itb);

  void  addGlAugmentedDisplay(tlp::GlAugmentedDisplay *augmentedDisplay, const char* key);
  void  removeGlAugmentedDisplay(tlp::GlAugmentedDisplay *augmentedDisplay);
  void  removeGlAugmentedDisplay(const char* key);
  tlp::GlAugmentedDisplay* findGlAugmentedDisplay(const char* key);

  /**
   * Function to do picking on augmented displays.  It just calls
   * doSelect on the GlADComposite instance.
   */
  inline bool doSelectAugmentedDisplay (const int x, const int y, 
					const int width, const int height,
					std::vector <std::pair <string, 
					tlp::GlAugmentedDisplay *> >
					&pickedAugmentedDisplays) {
    if (composite != 0)
      return composite->doSelect (x, y, width, height, pickedAugmentedDisplays,
				  this);
    else return false;
  }

  /**
   * Function to do picking on augmented displays.  It just calls
   * doSelect on the GlADComposite instance with a small window of 
   * twelve pixels.
   */
  inline bool doSelectAugmentedDisplay (const int x, const int y,
					std::vector <std::pair <string, 
					tlp::GlAugmentedDisplay *> >
					&pickedAugmentedDisplays) {
    if (composite != 0)
      return composite->doSelect (x-3, y-3, 6, 6, pickedAugmentedDisplays,
				  this);
    else return false;
  }

  /////////////////////////////////////

  //MouseInterface implementation can use the following methods. Not very pretty...
  //(but they cannot be declared "friend" since they will not be "friend" in turn)
  //update: use clickAt, the proper signal will be emitted
  void clickAt(const int x, const int y);
  void clickAt(const QPoint &pos);
//   void emitNodeClicked(const node &);
//   void emitEdgeClicked(const edge &);
  //
  
public slots:
//  void setGlGraph(GlGraph *);
  void setSuperGraph(SuperGraph *);
  void setMouse(MouseInterface *);
  //  void deleteElement(int x, int y);
  //  void delSelection();
  void redraw();
  //  void setContextCoord(int x, int y);
  //  void contextDel();
  //  void contextSelect();
  //  void contextProperties();
  //  void contextAddRemoveSelection();
  void closeEvent(QCloseEvent *e);

signals:
  void nodeClicked(SuperGraph *,const node &);
  void edgeClicked(SuperGraph *,const edge &);
  void closed(GlGraphWidget *);

protected slots:
  void drawGraph();
  void mouseReleaseEvent(QMouseEvent *e); 
  void mousePressEvent(QMouseEvent *e);
  void mouseMoveEvent(QMouseEvent *e);
  void keyPressEvent(QKeyEvent *e);
  void keyReleaseEvent(QKeyEvent *e);
  void wheelEvent(QWheelEvent *e);
#if (QT_REL == 4)
  bool event(QEvent *e);
#endif

private:

  QTimer *drawTimer;
  //  int xContext,yContext;
  MouseInterface *mouse;
  tlp::GlADComposite *composite;
};
/*@}*/
#endif
