/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>
    and authors of web browser Links 0.96

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"


void draw_inputln(struct inputln *il, int sel){

    /*dbg("draw_inputln (%d,%d)\n",il->x,il->y);*/
    if (il->vpos + il->l <= il->cpos) il->vpos = il->cpos - il->l + 1;
    if (il->vpos > il->cpos) il->vpos = il->cpos;
    if (il->vpos < 0) il->vpos = 0;
    fill_area(il->x, il->y, il->l, 1, COL_INV);
    
    print_text(il->x, il->y, strlen(il->cdata + il->vpos) <= il->l ? strlen(il->cdata + il->vpos) : il->l, il->cdata + il->vpos, COL_INV);

    if (il->focused) {
/*        dbg("draw_inputln: set_cursor %d %d \n", il->x + il->cpos - il->vpos, il->y);*/
        set_cursor(il->x + il->cpos - il->vpos, il->y, il->x + il->cpos - il->vpos, il->y);
    }
}

void clear_inputline(struct inputln *il){
    il->cpos = 0;
    memset(il->cdata,0,il->dlen);
}
    
void il_hist_check_bounds(struct inputln *il){
    if (il->hist_i < -1 ) il->hist_i = -1;
    if ((signed)il->hist_i >= (signed)il->history->len) il->hist_i = il->history->len - 1;
}

void il_add_to_history(struct inputln *il){
    if (strlen(il->cdata)==0) return;
    g_ptr_array_add(il->history, g_strdup(il->cdata));
    if (il->history->len == IL_HIST_LEN){
        gpointer p;
        p = g_ptr_array_index(il->history, 0);
        g_free(p);
        g_ptr_array_remove_index(il->history, 0);
    }
}

struct inputln *gil;

void il_history_func (union cba_t cba, union cba_t unused){
    int active;
    struct inputln *il;

    active=cba.int_;
    il=gil;
    
    if (active<0 || active>il->history->len) return;
    strncpy(il->cdata,
            g_ptr_array_index(il->history, active),
            il->dlen);
    redraw_later();
}

/* vraci 0 v pripade neobslouzeno */
int inputln_func(struct inputln *il, struct event *ev){

/*    dbg("inputln_func(%p,[%d,%d,%d,%d])\n",il,ev->ev,ev->x,ev->y,ev->b);*/
    
    switch (ev->ev) {
        case EV_INIT:
/*            dbg("inputln_func EV_INIT\n");*/
            il->x = 20;
            il->y = term->y - cfg->loglines - 1;
            if (il->band) il->y -= il->band->spypeers->len;
            
            il->l = 40;
            il->dlen = 256;
            if (!il->cdata)
               il->cdata=mem_alloc(il->dlen);

            memset(il->cdata,0,il->dlen);
            il->cpos = strlen(il->cdata);
            il->term = term;
            il->history = g_ptr_array_new();
            il->hist_i = -1;
            il_readonly(il, il->readonly);
            draw_inputln(il,1);/*FIXME*/
            
            break;
        case EV_RESIZE:
            if (il->sw){ 
                il->x = il->sw->x;
                il->y = il->sw->y + il->sw->h;
                il->l = il->sw->w;
            }else{
                il->x = 20;
                il->y = term->y - cfg->loglines - 1;
                if (il->band) il->y -= il->band->spypeers->len;
            }
            /*dbg("inputln_func RESIZE %p term->y=%d il->x=%d il->y=%d il->band=%p\n", il, term->y, il->x, il->y, il->band);*/
        
            
        case EV_REDRAW:      /* unreached for inputline in subwin */
/*            dbg("inputln_func EV_REDRAW\n");*/
            draw_inputln(il,1);/*FIXME*/
            break;
        case EV_KBD:
            if ((ev->y & KBD_CTRL) &&
                upcase(ev->x) == 'V' && il->allow_ctrlv){
                il->wasctrlv=1;
            }else{   
                if (il->wasctrlv){
                    il->wasctrlv=0;
/*                    dbg("ctrl+%c\n", ev->x); */
                    if (strlen(il->cdata) < il->dlen - 1) {
                        memmove(il->cdata + il->cpos + 1, il->cdata + il->cpos, strlen(il->cdata) - il->cpos + 1);
						if (ev->x=='[' || ev->x==']')
	                        il->cdata[il->cpos++] = ev->x;
						else
	                        il->cdata[il->cpos++] = tolower(ev->x)-'a'+1;
						
                    }
                    goto dsp_f;
                }
            }
            switch (kbd_action(KM_EDIT, ev)) {
                case ACT_RIGHT:
                    if (il->cpos < strlen(il->cdata)) il->cpos++;
                    goto dsp_f;
                case ACT_LEFT:
                    if (il->cpos > 0) il->cpos--;
                    goto dsp_f;
                case ACT_HOME:
                    il->cpos = 0;
                    goto dsp_f;
                case ACT_END:
                    il->cpos = strlen(il->cdata);
                    goto dsp_f;
                case ACT_BACKSPACE:
                    if (il->readonly) break;
                    if (il->cpos) {
                        memmove(il->cdata + il->cpos - 1, il->cdata + il->cpos, strlen(il->cdata) - il->cpos + 1);
                        il->cpos--;
                    }
                    goto dsp_f;
                case ACT_DELETE:
                    if (il->readonly) break;
                    if (il->cpos < strlen(il->cdata))
                        memmove(il->cdata + il->cpos, il->cdata + il->cpos + 1, strlen(il->cdata) - il->cpos + 1);
                    goto dsp_f;
                case ACT_KILL_LINE:
                    if (il->readonly) break;
                    clear_inputline(il);
                    goto dsp_f;    
                case ACT_KILL_TO_BOL:
                    if (il->readonly) break;
                    memmove(il->cdata, il->cdata + il->cpos, strlen(il->cdata + il->cpos) + 1);
                    il->cpos = 0;
                    goto dsp_f;
                case ACT_KILL_TO_EOL:
                    if (il->readonly) break;
                    il->cdata[il->cpos] = 0;
                    goto dsp_f;
                case ACT_PREV_HISTORY:    
                    if (il->readonly) break;
                    if (il->hist_i==-1 && strlen(il->cdata)>0){
                        il_add_to_history(il);
                        il->hist_i++;
                    }
                    il->hist_i++;
                    il_hist_check_bounds(il);
                    if (il->hist_i>=0)
                        strncpy(il->cdata,
                                g_ptr_array_index(il->history, il->history->len - il->hist_i - 1),
                                il->dlen);
                    else
                        strcpy(il->cdata, ""); /* FIXME */        
                    il->cpos = strlen(il->cdata);
                    goto dsp_f;
                    break;
                case ACT_NEXT_HISTORY:
                    if (il->readonly) break;
                    il->hist_i--;
                    il_hist_check_bounds(il);
                    if (il->hist_i>=0)
                        strncpy(il->cdata,
                                g_ptr_array_index(il->history, il->history->len - il->hist_i - 1),
                                il->dlen);
                    else
                        strcpy(il->cdata, ""); /* FIXME */        
                    il->cpos = strlen(il->cdata);
                    goto dsp_f;
                    break;
                case ACT_SHOW_HISTORY:{

                    int i;
                    struct menu_item *mi;
                    
                    gil=il;
                    if (il->history->len==0) break;
                    if (!(mi = new_menu(1))) break;
                    for (i = 0; i < il->history->len; i++) {
                        union cba_t cba2;
                        cba2.int_=i;
                        add_to_menu(&mi, g_ptr_array_index(il->history, i),
                                "", "", il_history_func, cba2, 0);
                    }
                    set_window_ptr(gses->win,il->x,il->y-2-i);
                    do_menu_selected(mi, (union cba_t)0, il->history->len-1);
                    
                    }goto dsp_f;
                case ACT_COPY_CLIPBOARD:
                    /* Copy to clipboard */
                    set_clipboard_text(il->cdata);
                    break;  /* We don't need to redraw */
                case ACT_CUT_CLIPBOARD:
                    if (il->readonly) break;
                    /* Cut to clipboard */                      
                    set_clipboard_text(il->cdata);
                    il->cdata[0] = 0;
                    il->cpos = 0;
                    goto dsp_f;
                case ACT_PASTE_CLIPBOARD: {
                    if (il->readonly) break;
                    /* Paste from clipboard */
 /*                   unsigned char * clipboard = get_clipboard_text();
                    strncpy(il->cdata , clipboard, il->item->dlen);
                    il->cdata[il->item->dlen - 1] = 0;
                    il->cpos = strlen(il->cdata);
                    mem_free(clipboard);*/
                    goto dsp_f;
                }
/*                case ACT_AUTO_COMPLETE: 
                      do_tab_compl(term, &il->history, win);
                    goto dsp_f;*/
                default:
                    if (ev->x >= ' ' && ev->x < 0x100 && !ev->y) {
                        if (il->readonly) break;
                        if (strlen(il->cdata) < il->dlen - 1) {
                            memmove(il->cdata + il->cpos + 1, il->cdata + il->cpos, strlen(il->cdata) - il->cpos + 1);
                            if (il->upconvert)
                                il->cdata[il->cpos++] = upcase(ev->x);
                            else
                                il->cdata[il->cpos++] = ev->x;
                        }
                        goto dsp_f;
                    }
                goto gh;
                dsp_f:
                draw_inputln(il,1);
                return 1;
            }
            gh:
            if (ev->x == KBD_ENTER) {
                if (il->readonly) return 1;
                if (!il->enter) return 1;
                /*dbg("inputln_func: KBD_ENTER '%s' \n",il->cdata);*/
                
                il_add_to_history(il);
                il->hist_i=-1;
                
                il->enter(il->enterdata, il->cdata);
                clear_inputline(il);
                draw_inputln(il,1);
                return 1;
            }
                
            break;
        case EV_MOUSE:
            if (ev->b & B_MOVE) break;
            if (ev->y != il->y || ev->x < il->x || ev->x >= il->x + il->l) return 0;
            if ((il->cpos = il->vpos + ev->x - il->x) > strlen(il->cdata)) il->cpos = strlen(il->cdata);
            draw_inputln(il,1);
            break;

        case EV_ABORT:
            if (il->cdata) mem_free(il->cdata);
            g_ptr_array_free_all(il->history);
            break;
    }
    return 0;
}

void il_set_focus(struct inputln *il){
    if (!il) return;  /* subwins having no inputline */
    il->focused=1;            
}

void il_unset_focus(struct inputln *il){
    if (!il) return;
    il->focused=0;
}

void il_readonly(struct inputln *il, int ro){
    
    il->readonly=ro;
    if (il->readonly)
        strncpy(il->cdata , VTEXT(T__RO_BAND), il->dlen);
    else
        strncpy(il->cdata , "", il->dlen);
}
