/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>
    and authors of tuxpaint http://www.newbreedsoftware.com/tuxpaint/

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/




#include "header.h"

#if defined(HAVE_SDL) && defined(HAVE_LIBPNG)
#include <png.h>

/* getpixel reads data from screen not surf! */
int do_png_save(SDL_Surface * surf, char * fname)
{
    png_structp png_ptr;
    png_infop info_ptr;
    png_text text_ptr[4];
    unsigned char ** png_rows;
    Uint8 r, g, b;
    int x, y, count;
    FILE *fi;

    fi=fopen(fname,"wb");
    if (!fi){
        return -1;
    }


    png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
    if (png_ptr == NULL)
    {
      fclose(fi);
      png_destroy_write_struct(&png_ptr, (png_infopp) NULL);
      return -2;
    }
    
    info_ptr = png_create_info_struct(png_ptr);
    if (info_ptr == NULL)
	{
        fclose(fi);
	    png_destroy_write_struct(&png_ptr, (png_infopp) NULL);
        return -3;
	}
	
	if (setjmp(png_jmpbuf(png_ptr)))
	{
	    fclose(fi);
	    png_destroy_write_struct(&png_ptr, (png_infopp) NULL);
	    return -4;
	}
	    
    png_init_io(png_ptr, fi);

    info_ptr->width = surf->w;
    info_ptr->height = surf->h;
    info_ptr->bit_depth = 8;
    info_ptr->color_type = PNG_COLOR_TYPE_RGB;
    info_ptr->interlace_type = 1;
    info_ptr->valid = 0;

    /* Set headers */

    count = 0;

    text_ptr[count].key = "Software";
    text_ptr[count].text = "Tucnak " VERSION;
    text_ptr[count].compression = PNG_TEXT_COMPRESSION_NONE;
    count++;

    png_set_text(png_ptr, info_ptr, text_ptr, count);
    png_write_info(png_ptr, info_ptr);

    /* Save the picture: */

    png_rows = malloc(sizeof(char *) * surf->h);

    for (y = 0; y < surf->h; y++)
    {
        png_rows[y] = malloc(sizeof(char) * 3 * surf->w);

        for (x = 0; x < surf->w; x++)
        {
            SDL_GetRGB(fast_getpixel32(x, y), surf->format, &r, &g, &b);

            png_rows[y][x * 3 + 0] = r;
            png_rows[y][x * 3 + 1] = g;
            png_rows[y][x * 3 + 2] = b;
        }
    }

    png_write_image(png_ptr, png_rows);

    for (y = 0; y < surf->h; y++)
    free(png_rows[y]);
    free(png_rows);

    png_write_end(png_ptr, NULL);
    png_destroy_write_struct(&png_ptr, &info_ptr);
    fclose(fi);

    return 0;
}
#endif
