/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"

#ifdef HAVE_SDL

struct cor *cor = NULL;

struct corarray *corarray_new(){
    struct corarray *ca;

    ca = g_new0(struct corarray, 1);
    ca->size=100;
    ca->data=g_new0(struct cpoint, ca->size);
    return ca;
}

void corarray_add(struct corarray *ca, struct cpoint *cp){
    if (ca->len == ca->size){
        ca->size+=100; 
        ca->data = g_renew(struct cpoint, ca->data, ca->size);
    }
    memcpy(&ca->data[ca->len], cp, sizeof(struct cpoint));    
    ca->len++;
}


void corarray_free(struct corarray *ca){
    g_free(ca->data);
    g_free(ca);
}

#define TO_READ 1000


struct cor *load_cor(char *filename){
    FILE *f;
    long  r; /* fixme only 32 bits, but... */
    int i,j;
    struct cpoint corbuf[TO_READ], *cp, cpfirst;
/*    int hh,ww,minh,maxh,minw,maxw;*/
    struct corarray *ca, *caold;
    
    if (sizeof(struct cpoint)!=5){
		dbg(TEXT(T_ALIGNMENT_DN), sizeof(struct cpoint));
		return NULL;
	}
	
	f=fopen(filename, "rb");
    if (!f) {
        return NULL;
    }

    cor = g_new0(struct cor, 1);
    
    for (i=0; i<COR_W; i++)
        for (j=0; j<COR_H; j++)
            cor->hash[j][i] = corarray_new();
    
    r=1;
    /*minh=minw=maxh=maxw=2;*/
    ca=caold=NULL;
    while (r>0){
	    r = fread(corbuf, sizeof(struct cpoint), TO_READ, f);
        
        for (i=0, cp=corbuf; i<r; i++, cp++){
            if (cp->c<0) {
                memcpy(&cpfirst, cp, sizeof(cpfirst));
            }
                
            ca=cor->hash[ /*hh=*/(cp->h/1000+COR_H/2-1)%COR_H ]
                        [ /*ww=*/(cp->w/1000+COR_W/2-1)%COR_W ];
            
            if (caold && ca!=caold) {
                corarray_add(caold, cp);
                cp->c=cpfirst.c;
            }
                
            corarray_add(ca, cp);
            caold=ca;


/*            if (hh<minh) minh=hh;
            if (ww<minw) minw=ww;
            if (hh>maxh) maxh=hh;
            if (ww>maxw) maxw=ww;*/
        }
    }
/*    dbg("h=%d %d\n", minh, maxh);
    dbg("w=%d %d\n", minw, maxw);*/
	fclose(f);

	return cor;
}

void free_cor(struct cor *cor){
    int i,j;

	if (!cor) return;

    for (i=0; i<COR_W; i++)
        for (j=0; j<COR_H; j++)
            corarray_free(cor->hash[j][i]);
	
    g_free(cor);
}
#endif /* HAVE_SDL */
