#define DEBUG
#define SYSCC
#undef DEBUG
#undef SYSCC

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <stddef.h>

/* default parameter for letter header printing */
#define HDR_RM 30
#define HDR_LM 72
#define HDR_BM 18	/* 72 */ 
#define HDR_TM 25 	/* 108 */
#define HDR_CX 74
#define HDR_CY 65
#define HDR_CS 0
#define HDR_LS 0.4
#define HDR_PGNO FALSE
#define HDR_DUP 0

/* default parameter for template printing */
#define TPL_PGNO FALSE
#define TPL_DUP 0 
#define TPL_COPY 1

/* allocate 100 pages of template buffer at start*/ 
#define TPL_PAGE 100
#define MAX_FAXPAGE 40

/* template command defines */
#define TPL_VPRINT 1
#define TPL_HPRINT 2
#define TPL_BC39 3
#define TPL_BC25 4
#define TPL_CODABAR 5


#define BOOL short
#define FALSE 0
#define TRUE 1
#define FONTNUM 6000	/* Maximun different font can be used */
#define PRECISION float
#define TAB     0x09
#define FF      0x0c      
#define MAXLINE 300


/* Error code definition */

#define E_FREE		0	/* Free from error */
#define E_NO_PAPER	1	/* No specified paper type */
#define E_NO_TMPF	2	/* Can't open temporary file */
#define E_NO_INF	3	/* Can't open input file */
#define E_NO_OUTF	4	/* Can't open output file */
#define E_NO_LOGF	5	/* Can't open log file */
#define E_NO_PSF	6	/* Can't open ps log file */
#define E_NO_FONTF	7	/* Can't open ttf font file */
#define E_NO_TPLF	8	/* Can't open template file */
#define E_NO_HDRF	9	/* Can't open Header file */
#define E_NO_MPHDRF	10	/* Can't open multi-page header file */
#define E_NO_FD		11	/* Run out of Font Dictionary */
#define E_MALLOC	12	/* Can't allocate memory */
#define E_REALLOC	13	/* Realloc memory fail */
#define E_TTF2PS	14	/* Error in ttf2ps */
#define E_TPLPG		15	/* Too Many template page data */
#define E_G3FAX		16	/* Can't generate G3 file */
#define E_FAXSPOOL	17	/* Error spool fax */
#define E_SENDFAX	18	/* Error execute sendfax */
#define E_FORK		19	/* Error to fork new process */
#define E_EXEC		20	/* Error to execute a process image */

#define FAX_SUCESS	0	/* sendfax sucessfully transmitted */
#define FAX_COMMAND	1	/* sendfax error on command line */
#define FAX_DEVICE	2	/* sendfax can't open fax device */
#define FAX_INIT	3	/* sendfax can't initialize modem */
#define FAX_BUSY	4	/* busy */
#define FAX_DIALTONE	5	/* No dialtone */
#define FAX_CARRIER	10	/* NO CARRIER or ERROR encountered*/
#define FAX_XON		11	/* Waiting for XON failed */
#define FAX_TRANSMIT	12	/* Transmitting page(s) failed */

struct font_data
	{
	struct font_data *pre;
	struct font_data *next;
	unsigned char code[2];
	int seq;
	char *outline;
	long count;
	BOOL dict;
	};

/* template printing command structure */
struct tpl_cmd
	{
	int cmd;
	PRECISION xcoor;
	PRECISION ycoor;
	PRECISION fs;		/* bh */
	PRECISION cs;		/* bw */
	char ft[20];
	char print_str[200];
	struct tpl_cmd *next;
	};

/* template printing page structure */
struct tpl_pagedata
  	{
  	char tpl_fn[30];
  	struct tpl_cmd *cmdlist;
  	struct tpl_cmd *cmdtail;
  	};

/* Fax number structure */
struct fax_num
  {
  struct fax_num *next;
  char phone[30];
  int status;
  };
  
/* Email address structure */
struct email
  {
  struct email *next;
  char addr[50]; 
  };

struct comment
  {
  struct comment *next;
  char string[100];
  };
   
struct err_cmd
  {
  struct err_cmd *next;
  char command[120];
  }; 
 