/* This file has been generated by the Perl script `afblue.pl', */
/* using data from file `./tablue.dat'.                         */

/* tablue.h */

/*
 * Copyright (C) 2013-2016 by Werner Lemberg.
 *
 * This file is part of the ttfautohint library, and may only be used,
 * modified, and distributed under the terms given in `COPYING'.  By
 * continuing to use, modify, or distribute this file you indicate that you
 * have read `COPYING' and understand and accept it fully.
 *
 * The file `COPYING' mentioned in the previous paragraph is distributed
 * with the ttfautohint library.
 */


/* originally file `afblue.h' (2013-Sep-11) from FreeType */


#ifndef TABLUE_H_
#define TABLUE_H_


  /* an auxiliary macro to decode a UTF-8 character -- since we only use */
  /* hard-coded, self-converted data, no error checking is performed */
#define GET_UTF8_CHAR(ch, p) \
  do \
  { \
    ch = (unsigned char)*p++; \
    if (ch >= 0x80) \
    { \
      FT_UInt len_; \
\
\
      if (ch < 0xE0) \
      { \
        len_ = 1; \
        ch &= 0x1F; \
      } \
      else if (ch < 0xF0) \
      { \
        len_ = 2; \
        ch &= 0x0F; \
      } \
      else \
      { \
        len_ = 3;\
        ch &= 0x07; \
      } \
\
      for (; len_ > 0; len_--) \
        ch = (ch << 6) | (*p++ & 0x3F); \
    } \
  } while (0)


/****************************************************************
 *
 *                        BLUE STRINGS
 *
 ****************************************************************/

/* At the bottommost level, we define strings for finding blue zones. */


#define TA_BLUE_STRING_MAX_LEN 27

/* The TA_Blue_String enumeration values are offsets into the */
/* `ta_blue_strings' array. */

typedef enum TA_Blue_String_
{
    TA_BLUE_STRING_ARABIC_TOP = 0,
    TA_BLUE_STRING_ARABIC_BOTTOM = 18,
    TA_BLUE_STRING_ARABIC_JOIN = 33,
    TA_BLUE_STRING_ARMENIAN_CAPITAL_TOP = 36,
    TA_BLUE_STRING_ARMENIAN_CAPITAL_BOTTOM = 60,
    TA_BLUE_STRING_ARMENIAN_SMALL_ASCENDER = 84,
    TA_BLUE_STRING_ARMENIAN_SMALL_TOP = 105,
    TA_BLUE_STRING_ARMENIAN_SMALL_BOTTOM = 129,
    TA_BLUE_STRING_ARMENIAN_SMALL_DESCENDER = 153,
    TA_BLUE_STRING_BENGALI_BASE = 177,
    TA_BLUE_STRING_BENGALI_TOP = 209,
    TA_BLUE_STRING_BENGALI_HEAD = 237,
    TA_BLUE_STRING_CHEROKEE_CAPITAL = 269,
    TA_BLUE_STRING_CHEROKEE_SMALL_ASCENDER = 301,
    TA_BLUE_STRING_CHEROKEE_SMALL = 333,
    TA_BLUE_STRING_CHEROKEE_SMALL_DESCENDER = 365,
    TA_BLUE_STRING_CYRILLIC_CAPITAL_TOP = 381,
    TA_BLUE_STRING_CYRILLIC_CAPITAL_BOTTOM = 405,
    TA_BLUE_STRING_CYRILLIC_SMALL = 429,
    TA_BLUE_STRING_CYRILLIC_SMALL_DESCENDER = 453,
    TA_BLUE_STRING_DEVANAGARI_BASE = 462,
    TA_BLUE_STRING_DEVANAGARI_TOP = 494,
    TA_BLUE_STRING_DEVANAGARI_HEAD = 526,
    TA_BLUE_STRING_DEVANAGARI_BOTTOM = 558,
    TA_BLUE_STRING_ETHIOPIC_TOP = 566,
    TA_BLUE_STRING_ETHIOPIC_BOTTOM = 598,
    TA_BLUE_STRING_GEORGIAN_MKHEDRULI_TOP = 630,
    TA_BLUE_STRING_GEORGIAN_MKHEDRULI_BOTTOM = 662,
    TA_BLUE_STRING_GEORGIAN_MKHEDRULI_ASCENDER = 694,
    TA_BLUE_STRING_GEORGIAN_MKHEDRULI_DESCENDER = 726,
    TA_BLUE_STRING_GEORGIAN_ASOMTAVRULI_TOP = 758,
    TA_BLUE_STRING_GEORGIAN_ASOMTAVRULI_BOTTOM = 790,
    TA_BLUE_STRING_GEORGIAN_NUSKHURI_TOP = 822,
    TA_BLUE_STRING_GEORGIAN_NUSKHURI_BOTTOM = 854,
    TA_BLUE_STRING_GEORGIAN_NUSKHURI_ASCENDER = 886,
    TA_BLUE_STRING_GEORGIAN_NUSKHURI_DESCENDER = 918,
    TA_BLUE_STRING_GREEK_CAPITAL_TOP = 950,
    TA_BLUE_STRING_GREEK_CAPITAL_BOTTOM = 971,
    TA_BLUE_STRING_GREEK_SMALL_BETA_TOP = 989,
    TA_BLUE_STRING_GREEK_SMALL = 1007,
    TA_BLUE_STRING_GREEK_SMALL_DESCENDER = 1031,
    TA_BLUE_STRING_GUJARATI_TOP = 1055,
    TA_BLUE_STRING_GUJARATI_BOTTOM = 1087,
    TA_BLUE_STRING_GUJARATI_ASCENDER = 1119,
    TA_BLUE_STRING_GUJARATI_DESCENDER = 1169,
    TA_BLUE_STRING_GUJARATI_DIGIT_TOP = 1202,
    TA_BLUE_STRING_GURMUKHI_BASE = 1222,
    TA_BLUE_STRING_GURMUKHI_HEAD = 1254,
    TA_BLUE_STRING_GURMUKHI_TOP = 1286,
    TA_BLUE_STRING_GURMUKHI_BOTTOM = 1318,
    TA_BLUE_STRING_GURMUKHI_DIGIT_TOP = 1350,
    TA_BLUE_STRING_HEBREW_TOP = 1370,
    TA_BLUE_STRING_HEBREW_BOTTOM = 1394,
    TA_BLUE_STRING_HEBREW_DESCENDER = 1412,
    TA_BLUE_STRING_KANNADA_TOP = 1427,
    TA_BLUE_STRING_KANNADA_BOTTOM = 1471,
    TA_BLUE_STRING_KHMER_TOP = 1503,
    TA_BLUE_STRING_KHMER_SUBSCRIPT_TOP = 1527,
    TA_BLUE_STRING_KHMER_BOTTOM = 1567,
    TA_BLUE_STRING_KHMER_DESCENDER = 1599,
    TA_BLUE_STRING_KHMER_LARGE_DESCENDER = 1633,
    TA_BLUE_STRING_KHMER_SYMBOLS_WAXING_TOP = 1720,
    TA_BLUE_STRING_KHMER_SYMBOLS_WANING_BOTTOM = 1728,
    TA_BLUE_STRING_LAO_TOP = 1736,
    TA_BLUE_STRING_LAO_BOTTOM = 1768,
    TA_BLUE_STRING_LAO_ASCENDER = 1800,
    TA_BLUE_STRING_LAO_LARGE_ASCENDER = 1816,
    TA_BLUE_STRING_LAO_DESCENDER = 1828,
    TA_BLUE_STRING_LATIN_CAPITAL_TOP = 1852,
    TA_BLUE_STRING_LATIN_CAPITAL_BOTTOM = 1868,
    TA_BLUE_STRING_LATIN_SMALL_F_TOP = 1884,
    TA_BLUE_STRING_LATIN_SMALL = 1898,
    TA_BLUE_STRING_LATIN_SMALL_DESCENDER = 1912,
    TA_BLUE_STRING_LATIN_SUBS_CAPITAL_TOP = 1922,
    TA_BLUE_STRING_LATIN_SUBS_CAPITAL_BOTTOM = 1942,
    TA_BLUE_STRING_LATIN_SUBS_SMALL_F_TOP = 1962,
    TA_BLUE_STRING_LATIN_SUBS_SMALL = 1982,
    TA_BLUE_STRING_LATIN_SUBS_SMALL_DESCENDER = 2018,
    TA_BLUE_STRING_LATIN_SUPS_CAPITAL_TOP = 2038,
    TA_BLUE_STRING_LATIN_SUPS_CAPITAL_BOTTOM = 2069,
    TA_BLUE_STRING_LATIN_SUPS_SMALL_F_TOP = 2098,
    TA_BLUE_STRING_LATIN_SUPS_SMALL = 2124,
    TA_BLUE_STRING_LATIN_SUPS_SMALL_DESCENDER = 2149,
    TA_BLUE_STRING_MALAYALAM_TOP = 2160,
    TA_BLUE_STRING_MALAYALAM_BOTTOM = 2204,
    TA_BLUE_STRING_MYANMAR_TOP = 2236,
    TA_BLUE_STRING_MYANMAR_BOTTOM = 2268,
    TA_BLUE_STRING_MYANMAR_ASCENDER = 2300,
    TA_BLUE_STRING_MYANMAR_DESCENDER = 2328,
    TA_BLUE_STRING_SINHALA_TOP = 2360,
    TA_BLUE_STRING_SINHALA_BOTTOM = 2392,
    TA_BLUE_STRING_SINHALA_DESCENDER = 2424,
    TA_BLUE_STRING_TAMIL_TOP = 2468,
    TA_BLUE_STRING_TAMIL_BOTTOM = 2500,
    TA_BLUE_STRING_TELUGU_TOP = 2532,
    TA_BLUE_STRING_TELUGU_BOTTOM = 2560,
    TA_BLUE_STRING_THAI_TOP = 2588,
    TA_BLUE_STRING_THAI_BOTTOM = 2612,
    TA_BLUE_STRING_THAI_ASCENDER = 2640,
    TA_BLUE_STRING_THAI_LARGE_ASCENDER = 2652,
    TA_BLUE_STRING_THAI_DESCENDER = 2664,
    TA_BLUE_STRING_THAI_LARGE_DESCENDER = 2680,
    TA_BLUE_STRING_THAI_DIGIT_TOP = 2688,


  TA_BLUE_STRING_MAX   /* do not remove */
} TA_Blue_String;


extern const char ta_blue_strings[];


/****************************************************************
 *
 *                      BLUE STRINGSETS
 *
 ****************************************************************/

/* The next level is to group blue strings into style-specific sets. */


/* Properties are specific to a writing system.  We assume that a given */
/* blue string can't be used in more than a single writing system, which */
/* is a safe bet. */
#define TA_BLUE_PROPERTY_LATIN_TOP (1U << 0) /* must have value 1 */
#define TA_BLUE_PROPERTY_LATIN_SUB_TOP (1U << 1)
#define TA_BLUE_PROPERTY_LATIN_NEUTRAL (1U << 2)
#define TA_BLUE_PROPERTY_LATIN_X_HEIGHT (1U << 3)
#define TA_BLUE_PROPERTY_LATIN_LONG (1U << 4)


#define TA_BLUE_STRINGSET_MAX_LEN 8

/* The TA_Blue_Stringset enumeration values are offsets into the */
/* `ta_blue_stringsets' array. */

typedef enum TA_Blue_Stringset_
{
    TA_BLUE_STRINGSET_ARAB = 0,
    TA_BLUE_STRINGSET_ARMN = 4,
    TA_BLUE_STRINGSET_BENG = 11,
    TA_BLUE_STRINGSET_CHER = 16,
    TA_BLUE_STRINGSET_CYRL = 23,
    TA_BLUE_STRINGSET_DEVA = 29,
    TA_BLUE_STRINGSET_ETHI = 35,
    TA_BLUE_STRINGSET_GEOR = 38,
    TA_BLUE_STRINGSET_GEOK = 43,
    TA_BLUE_STRINGSET_GREK = 50,
    TA_BLUE_STRINGSET_GUJR = 57,
    TA_BLUE_STRINGSET_GURU = 63,
    TA_BLUE_STRINGSET_HEBR = 69,
    TA_BLUE_STRINGSET_KNDA = 73,
    TA_BLUE_STRINGSET_KHMR = 76,
    TA_BLUE_STRINGSET_KHMS = 82,
    TA_BLUE_STRINGSET_LAO = 85,
    TA_BLUE_STRINGSET_LATN = 91,
    TA_BLUE_STRINGSET_LATB = 98,
    TA_BLUE_STRINGSET_LATP = 105,
    TA_BLUE_STRINGSET_MLYM = 112,
    TA_BLUE_STRINGSET_MYMR = 115,
    TA_BLUE_STRINGSET_NONE = 120,
    TA_BLUE_STRINGSET_SINH = 121,
    TA_BLUE_STRINGSET_TAML = 125,
    TA_BLUE_STRINGSET_TELU = 128,
    TA_BLUE_STRINGSET_THAI = 131,


  TA_BLUE_STRINGSET_MAX   /* do not remove */
} TA_Blue_Stringset;


typedef struct TA_Blue_StringRec_
{
  TA_Blue_String string;
  FT_UShort properties;
} TA_Blue_StringRec;


extern const TA_Blue_StringRec ta_blue_stringsets[];

#endif /* TABLUE_H_ */

/* end of tablue.h */
