/*
 * Copyright (C) 2001 Michael Schmitt <schmitt@itm.mu-luebeck.de>
 *
 *    Institute for Telematics,
 *    Medical University of Luebeck,
 *    Ratzeburger Allee 160,
 *    23538 Luebeck,
 *    Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include <cstdarg>
#include "EnvAST.hpp"

ANTLR_BEGIN_NAMESPACE(antlr)

EnvAST::EnvAST()
{
}


EnvAST::EnvAST( RefToken t ) : InfoAST( t )
{
}

void  EnvAST::setParentEnv( RefEnvAST p ) {
  parentEnv = p;
}

RefEnvAST  EnvAST::getParentEnv () const {
  return parentEnv;
}

void  EnvAST::addASTList (int count, ASTFactory *factory, ...) {
  va_list  ap;
  va_start(ap,factory);
  for (int i = 0; i < count; i++) {
    RefAST  ast = *(va_arg(ap,RefAST*));
    if (ast.get() && ast != antlr::nullAST) {
      addChild(factory->dupTree(ast));
    }
  }
  va_end(ap);
}

void  EnvAST::addASTList (RefAST ast, int count, ASTFactory *factory, ...) {
  va_list  ap;
  va_start(ap,factory);
  for (int i = 0; i < count; i++) {
    RefAST  ast2 = *(va_arg(ap,RefAST*));
    if (ast2.get() && ast2 != antlr::nullAST) {
      ast->addChild(factory->dupTree(ast2));
    }
  }
  va_end(ap);
}

RefAST  EnvAST::factory()
{
  return RefAST( new EnvAST );
}


ANTLR_END_NAMESPACE
