/**
 * Copyright, (c) Pete Goodliffe 2000
 * pete.goodliffe@pace.co.uk
 */

#include "tse3/Notifier.h"

#include <iostream>

/*
* This is a simple test of the Notifier framework, and a simple example
 * of how to use it.
 */

using namespace TSE3;

class Exhibitionist;

/**
 * Listener interface for the Exhibitionist class.
 */
class ExhibitionistListener
{
    public:
        typedef Exhibitionist notifier_type;

        virtual void Exhibitionist_Status(Exhibitionist*) = 0;
        virtual void Exhibitionist_Fish(Exhibitionist*)   = 0;
};


/**
 * Example Notifier class.
 */
class Exhibitionist : public Notifier<ExhibitionistListener>
{
    public:
        void perform()
        {
            notify(&ExhibitionistListener::Exhibitionist_Status);
            notify(&ExhibitionistListener::Exhibitionist_Fish);
        }
};

/**
 * Example listener class
 */
class Voyeur : public Listener<ExhibitionistListener>
{
    public:
        virtual void Exhibitionist_Status(Exhibitionist*)
        {
            std::cout << "  Exhibitionist has status\n";
        }
        virtual void Exhibitionist_Fish(Exhibitionist*)
        {
            std::cout << "  Exhibitionist has fish\n ";
        }
        virtual void Notifier_Deleted(Exhibitionist* /*src*/)
        {
            std::cout << "  Exhibitionist has been deleted\n";
        }
};

/******************************************************************************
 * Test two: identical, just different names
 *****************************************************************************/
class Exhibitionist2;
#if 0
/**
 * Listener interface for the Exhibitionist class.
 */
class ExhibitionistListener2
{
    public:
        typedef Exhibitionist2 notifier_type;

        virtual void Exhibitionist_Status(Exhibitionist2*) = 0;
        virtual void Exhibitionist_Fish(Exhibitionist2*)   = 0;
};


/**
 * Example Notifier class.
 */
class Exhibitionist2 : public Notifier<ExhibitionistListener2>
{
    public:
        void perform()
        {
            notify(&ExhibitionistListener2::Exhibitionist_Status);
            notify(&ExhibitionistListener2::Exhibitionist_Fish);
        }
};

/**
 * Example listener class
 */
class Voyeur2 : public Listener<ExhibitionistListener2>
{
    public:
        virtual void Exhibitionist_Status(Exhibitionist2*)
        {
            std::cout << "  Exhibitionist has status\n";
        }
        virtual void Exhibitionist_Fish(Exhibitionist2*)
        {
            std::cout << "  Exhibitionist has fish\n ";
        }
        virtual void Notifier_Deleted(Exhibitionist2* /*src*/)
        {
            std::cout << "  Exhibitionist has been deleted\n";
        }
};
#endif
int main()
{
    /************
     * TEST ONE
     ***********/
    std::cout << "--- TEST ONE ---------------------------\n\n";
    {
        /* Example 1:
         *   Create a Voyeur then an Exhibitionist.
         *   When the Exhibitonist is deleted, the Voyeur recieves an event.
         */
        std::cout << "* Example 1: Creating some objects...\n";
        Voyeur        v;
        Exhibitionist e;
        std::cout << "  done\n";

        std::cout << "* Attaching\n";
        v.attachTo(&e);
        std::cout << "  done\n";

        std::cout << "* Doing something\n";
        e.perform();
        std::cout << "  done\n";

        std::cout << "* Deleting Exhbitionist (then Voyeur)\n";
    }
    std::cout << "  done\n";

    std::cout << "\n\n";

    {
        /* Example 2:
         *   Create an Exhibitionist and then a Voyeur.
         *   When the Voyeur is deleted, it is automatically detached from
         *   the Exhibitionist (even though it did not automatically do it
         *   itself). Now when the Exhbitionist sends its deleted event
         *   the (deleted) Voyeur is not called, and we don't crash.
         */
        std::cout << "* Example 2: Creating some objects...\n";
        Exhibitionist e;
        Voyeur        v;
        std::cout << "  done\n";

        std::cout << "* Attaching\n";
        v.attachTo(&e);
        std::cout << "  done\n";

        std::cout << "* Doing something\n";
        e.perform();
        std::cout << "  done\n";

        std::cout << "* Deleting Voyeur then Exhbitionist (=> no event)\n";
    }
    std::cout << "  done\n";
#if 0
    /************
     * TEST TWO
     ***********/
    std::cout << "--- TEST ONE ---------------------------\n\n";
    {
        /* Example 1:
         *   Create a Voyeur then an Exhibitionist.
         *   When the Exhibitonist is deleted, the Voyeur recieves an event.
         */
        std::cout << "* Example 1: Creating some objects...\n";
        Voyeur2        v;
        Exhibitionist2 e;
        std::cout << "  done\n";

        std::cout << "* Attaching\n";
        v.attachTo(&e);
        std::cout << "  done\n";

        std::cout << "* Doing something\n";
        e.perform();
        std::cout << "  done\n";

        std::cout << "* Deleting Exhbitionist (then Voyeur)\n";
    }
    std::cout << "  done\n";

    std::cout << "\n\n";

    {
        /* Example 2:
         *   Create an Exhibitionist and then a Voyeur.
         *   When the Voyeur is deleted, it is automatically detached from
         *   the Exhibitionist (even though it did not automatically do it
         *   itself). Now when the Exhbitionist sends its deleted event
         *   the (deleted) Voyeur is not called, and we don't crash.
         */
        std::cout << "* Example 2: Creating some objects...\n";
        Exhibitionist2 e;
        Voyeur2        v;
        std::cout << "  done\n";

        std::cout << "* Attaching\n";
        v.attachTo(&e);
        std::cout << "  done\n";

        std::cout << "* Doing something\n";
        e.perform();
        std::cout << "  done\n";

        std::cout << "* Deleting Voyeur then Exhbitionist (=> no event)\n";
    }
    std::cout << "  done\n";
#endif
    return 0;
}
