// ti994.h - TI-99/4(A) Emulator Definitions
//
// Copyright (c) 2002, Timothy M. Stark
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// TIMOTHY M STARK BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name of Timothy M Stark shall not
// be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from
// Timothy M Stark.

#include "ti99/defs.h"

#define TI994_KEY      "TI-99/4"
#define TI994_NAME     "TI-99/4 Home Computer Emulator"

#define TI994A_KEY     "TI-99/4A"
#define TI994A_NAME    "TI-99/4A Home Computer Emulator"

#define TI994X_VERSION "v0.1 (Alpha)"

typedef struct ti994_Processor TI994_CPU;  // For TI-99/4 Computer
typedef struct ti994_Processor TI994A_CPU; // For TI-99/4A Computer

struct ti994_Processor {
	TI99_CPU cpu; // Processor Header

	TI99_SYSTEM *System;

	CLK_QUEUE   SystemTimer;
	uint32      TickClock;

	uint16   *ROM;
	uint16   baseROM;
	uint16   endROM;
	uint16   sizeROM;
	uint16   maskROM;

	uint16   padRAM[128];
	uint16   grmAddr;

	uint16   *cpuMemory;
	uint8    *gplMemory;
};

#define WP       TI99->cpu.wp
#define PC       TI99->cpu.pc
#define ST       TI99->cpu.st
#define CC       TI99->cpu.cc

#define IPS      TI99->cpu.ips

#define ReadW    TI99->cpu.ReadW
#define WriteW   TI99->cpu.WriteW
#define ReadB    TI99->cpu.ReadB
#define WriteB   TI99->cpu.WriteB
#define ReadCRU  TI99->cpu.ReadCRU
#define WriteCRU TI99->cpu.WriteCRU

#define EnableTimer  TI99->cpu.EnableTimer
#define DisableTimer TI99->cpu.DisableTimer

