// mrv.h - MRV11 Boot ROM Device Definitions
//
// Copyright (c) 2002, Timothy M. Stark
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// TIMOTHY M STARK BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name of Timothy M Stark shall not
// be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from
// Timothy M Stark.

#define MRV_KEY     "MRV11"
#define MRV_NAME    "Boot ROM Device"
#define MRV_VERSION "v0.7 (Alpha)"

#include "dev/defs.h"

// BDV11/KDF11 Unibus/QBus I/O Address:
//
// 765xxx ROM - (R)   ROM Page 1 Area (256 bytes window)
// 773xxx ROM - (R)   ROM Page 0 Area (256 bytes window)
// 777520 PCR - (R/W) Page Control Register
// 777522 SPR - (R/W) Maintenance Register
// 777524 OSR - (R)   Configuration Register
// 777524 DSP - (W)   Display LEDs (4b)

#define nPCR  0  // Page Control Register
#define nMR   1  // Maintenance Register
#define nCR   2  // Configuration Register
#define nDSP  2  // Display LED Register

#define PCR  mrv->pcr
#define MR   mrv->mr
#define CR   mrv->cr
#define DSP  mrv->dsp

#define MRV_CSRADR  0777520    // CSR Device Address
#define MRV_NREGS   3          // Number of Registers
#define PCR_MASK    0377       // Page Number Mask
#define ROM_PAGE0   0773000    // ROM Page 0 Window Address
#define ROM_PAGE1   0765000    // ROM Page 1 Window Address
#define ROM_WSIZE   256        // Window Size
#define ROM_PAGE    0777       // Offset Address Field
#define ROM_SIZE    (1u << 17) // Maximum 128K ROM Size

typedef struct mrv_Device MRV_ROM;

struct mrv_Device {
	UNIT    Unit;         // Unit Header Information
	void    *System;      // System device
	void    *Device;      // Unibus/QBus Interface
	UQ_CALL *Callback;    // Callback functions

	// I/O Map Area
	MAP_IO  ioMap;        // MRV11 Register Area
	MAP_IO  ioPage0;      // ROM Window Area
	MAP_IO  ioPage1;      // ROM Window Area

	// Unibus/Qbus Registers
	uint16  pcr;          // Page Control Register
	uint16  mr;           // Maintenance Register
	uint16  cr;           // Configuration Register
	uint16  dsp;          // Display Register

	// Internal Registers
	uint32  Page0;        // ROM Page 0 Address
	uint32  Page1;        // ROM Page 1 Address

	// ROM Image Information
	char    *romFile;     // ROM Filename
	uint8   *romImage;    // ROM Image
	uint32  romSize;      // ROM Size
};
