/*
 * Copyright(c) 2008, MQSoftware, Inc.
 * All rights reserved.
 */
package gnu.trove;

import java.util.ArrayList;
import java.util.List;


/**
 *
 */
public class THashSetBug {
	private static final void time(final int numSamples,
        final int cycles, final List<Integer> objects, final boolean forceCompaction) {

        long time = 0;

		for (int i=0; i < numSamples; i++) {
			THashSet<Integer> set = new THashSet<Integer>();
            final int size = objects.size();
            for ( int j = 0 ; j < size; j++ ) {
				set.add( objects.get( j ) );
			}

//			for (int j=0; j < cycles; j++) {
				long start = System.nanoTime();//System.currentTimeMillis();
				set.clear();
				if (forceCompaction) set.compact();
				long stop = System.nanoTime();//System.currentTimeMillis();

				time += stop - start;
//			}
		}

		System.out.print(forceCompaction ? "WITH COMPACTION: " : "AS-IS: ");
		System.out.println(time / numSamples + " ms ");
	}

	public static void main(String[] args) {
		final int numSamples = 500;
		final int cycles = 1000;
		final int size = 50000;


		ArrayList<Integer> objects = new ArrayList<Integer>();
		for (int j=0; j < size; j++) {
			objects.add(new Integer(j));
		}

        // do timing
        while( true ) {
            time(numSamples, cycles, objects, false);
//            time(numSamples, cycles, objects, true);
        }

        // verify timing consistency
//		time(numSamples, cycles, objects, false);
//		time(numSamples, cycles, objects, true);
//
//		time(numSamples, cycles, objects, false);
//		time(numSamples, cycles, objects, true);
//
//		time(numSamples, cycles, objects, false);
//		time(numSamples, cycles, objects, true);


	}

}
