#include "caimageview.h"
#include "caresources.h"
#include "catrophy.h"


/** Constructor for an empty image view.
*/
CAImageView::CAImageView()
        : CAWidget( CAWidget::Left ) {
    if( CA_APP->debug ) std::cout << "CAImageView() begin" << std::endl;

    barHeight = CA_RES->font_normal_14_white->get_height() + 6;
    image.image = 0;

    if( CA_APP->debug ) std::cout << "CAImageView() end" << std::endl;
}



/** Constructor for an image view with already one image.
    \param upperText Text above image
    \param lowerText Text under image
    \param image The image itself
    \param autoresize Automatically resize the image preview 
                      to fit the image.
*/
CAImageView::CAImageView( const char* upperText,
                          const char* lowerText,
                          CL_Surface* image,
                          bool autoResize )
        : CAWidget( CAWidget::Left ) {
    if( CA_APP->debug ) std::cout << "CAImageView() begin 2" << std::endl;

    barHeight = CA_RES->font_normal_14_white->get_height() + 6;
    this->image.upperText = upperText;
    this->image.lowerText = lowerText;
    this->image.image = image;

    if( autoResize ) {
        setImageSize( image->get_width(), image->get_height() );
    }

    if( CA_APP->debug ) std::cout << "CAImageView() end 2" << std::endl;
}



/** Destructor.
*/
CAImageView::~CAImageView() {}



/** Sets the size of the image view (without top/bottom button).
    Bigger images get cropped (top left part shown).
    \param w Width of image view
    \param h Height of image view
*/
void
CAImageView::setImageSize( int w, int h ) {
    width = w;
    height = h + barHeight * 2;
    right = left + width;
    bottom = top + height;
}



/** Displays the image view with its current image/ texts.
*/
void
CAImageView::display( bool active ) {
    CL_ClipRect crAll( 0,0, CA_APP->width, CA_APP->height );
    CL_ClipRect crImage( left,top, right, bottom );
    CL_Display::set_clip_rect( crImage );
    CL_Display::fill_rect( left,top, right,bottom, 0.0,0.0,0.0, 0.25 );

    if( image.image ) image.image->put_screen( left,
                top+barHeight );

    displayTextButtons( active );

    CL_Display::set_clip_rect( crAll );
}



/** Displays the arrows for selectors (used for base classes).
*/
void
CAImageView::displayArrows( bool active ) {
    // Selector arrows show the direction of possible movements:
    //
    if( direction==Horizontal ) {
        int arrowHeight = CA_RES->gui_arrow_l->get_height();
        int arrowWidth = CA_RES->gui_arrow_l->get_width();
        CA_RES->gui_arrow_l->put_screen( left, top+height/2-arrowHeight/2 );
        CA_RES->gui_arrow_r->put_screen( right-arrowWidth, top+height/2-arrowHeight/2 );
    } else {
        int arrowHeight = CA_RES->gui_arrow_t->get_height();
        int arrowWidth = CA_RES->gui_arrow_t->get_width();
        CA_RES->gui_arrow_t->put_screen( (left+right)/2-arrowWidth/2, top+barHeight );
        CA_RES->gui_arrow_b->put_screen( (left+right)/2-arrowWidth/2, bottom-barHeight-arrowHeight );
    }
}



/** Displays the buttons on top/ button with their texts.
*/
void
CAImageView::displayTextButtons( bool active ) {
    // Buttons:
    //
    CA_RES->gui_button->put_screen( left, top, width, barHeight );
    CA_RES->gui_button->put_screen( left, top+height-barHeight, width, barHeight );

    // Texts:
    //
    int textPosX = left + width/2;
    int textPosY = top + 6;
    CA_RES->font_normal_14_white->print_center( textPosX, textPosY,
            image.upperText );
    textPosY = top + height - barHeight + 6;
    CA_RES->font_normal_14_white->print_center( textPosX, textPosY,
            image.lowerText );
}



/** Handles key events for this view (no action).
*/
void
CAImageView::handleKey( const CL_Key &key ) {}


// EOF
