/*
	**
	** report.h
	**
	** Routines and data structures used to store and manage packet 
	** summary report
	**
	** Copyright 1998-1999 Damien Miller <dmiller@ilogic.com.au>
	**
	** This software is licensed under the terms of the GNU General 
	** Public License (GPL). Please see the file COPYING for details.
	** 
	** $Id: report.h,v 1.3 1999/02/10 11:16:47 dmiller Exp $
	**
 */

#ifndef _REPORT_H
#define _REPORT_H

#include <time.h>
#include <sys/types.h>

typedef struct PEER
{
	struct HOST		*src;
	struct HOST		*dst;
	u_int32_t		src_addr;
	u_int32_t		dst_addr;
	u_int64_t		bytes_sent;
	u_int64_t		packets_sent;
	u_int64_t		connections_sent;
	struct PEER		*next;
} peer_t;

typedef struct HOST
{
	u_int32_t		ip_addr;
	char				*hostname;
	u_int64_t		bytes_sent;
	u_int64_t		bytes_received;
	u_int64_t		packets_sent;
	u_int64_t		packets_received;
	u_int64_t		connections_sent;
	u_int64_t		connections_received;
	time_t			first_seen;
	time_t			last_seen;
	peer_t			*peers;
	u_int32_t		n_peers;
	struct HOST		*next;
} host_t;

typedef struct
{
	u_int64_t		total_bytes;
	u_int64_t		total_packets;
	u_int64_t		total_connections;
	time_t			summary_start;
	time_t			summary_finish;
	u_int32_t		active_hosts;
	host_t			*hosts;
} report_t;

void free_report(report_t *r);
void free_host(host_t *h);
void free_hosts(host_t *h);
void free_peer(peer_t *p);
void free_peers(peer_t *p);
unsigned int host_hash(u_int32_t *ip_addr);
unsigned int host_compare(u_int32_t *ip_addr1, u_int32_t *ip_addr2);
void resolve_hosts(host_t *h);

#endif /* _REPORT_H */
