/*
	**
	** packet-summary.h
	**
	** Stores and retrieves information about collections of packets
	**
	** Copyright 1998-1999 Damien Miller <dmiller@ilogic.com.au>
	**
	** This software is licensed under the terms of the GNU General 
	** Public License (GPL). Please see the file COPYING for details.
	** 
	** $Id: packet-summary.h,v 1.2 1999/02/04 10:22:42 dmiller Exp $
	**
 */

#ifndef _PACKET_SUMMARY_H
#define _PACKET_SUMMARY_H

#include "packet-parse.h"
#include "summary-structures.h"

/* Sets up packet summary data structures */
void packet_summary_init(summary_t **ps);

/* Deallocates packet summary data structures */
void packet_summary_free(summary_t *ps);

/* Adds a packet's information to the summary */
void store_packet_info(summary_t *ps, packet_info_t *pinfo);

/* Compare's two hosts IP addresses to determine whether they are equal */
unsigned int	host_compare(u_int32_t *ip_addr1, u_int32_t *ip_addr2);

/* Hashes a host's IP address to an unsigned integer */
unsigned int	host_hash(u_int32_t *ip_addr);

#endif
