/*
	**
	** packet-headers.h
	**
	** Structures describing network packet headers
	**
	** Copyright 1998-1999 Damien Miller <dmiller@ilogic.com.au>
	**
	** This software is licensed under the terms of the GNU General 
	** Public License (GPL). Please see the file COPYING for details.
	** 
	** $Id: packet-headers.h,v 1.4 1999/02/11 03:17:28 dmiller Exp $
	**
 */

#ifndef _PACKET_HEADERS_H
#define _PACKET_HEADERS_H

#include "sys/types.h"

#define FDDIFC_CLFF			0xF0	/* FDDI frame control mask */
#define FDDIFC_LLC_ASYNC	0x50	/* FDDI LLC frame type */

/* FDDI MAC header */
struct fddi_hdr
{
	u_int8_t		frame_control;
	u_int8_t		src_addr[6];
	u_int8_t		dst_addr[6];
	u_int8_t		dsap;
	u_int8_t		ssap;
	u_int8_t		cntrl;
	u_int8_t		vendorid[3];
	u_int16_t	type;
};

/* Ethernet (RFC894) MAC header */
struct eth_mac_hdr
{
	u_int8_t		src_addr[6];
	u_int8_t		dst_addr[6];
	u_int16_t	type;
};

struct ip_hdr
{
#if __BYTE_ORDER == __LITTLE_ENDIAN
	u_int8_t		ihl:4;
	u_int8_t		version:4;
#elif __BYTE_ORDER == __BIG_ENDIAN
	u_int8_t		version:4;
	u_int8_t		ihl:4;
#else
#error	"Please define __BYTE_ORDER to __BIG_ENDIAN or __LITTLE_ENDIAN"
#endif
	u_int8_t		tos;
	u_int16_t	tot_len;
	u_int16_t	id;
	u_int16_t	frag_off;
	u_int8_t		ttl;
	u_int8_t		protocol;
	u_int16_t	check;
	u_int32_t	saddr;
	u_int32_t	daddr;
};

struct udp_hdr {
	u_int16_t	source;
	u_int16_t	dest;
	u_int16_t	len;
	u_int16_t	check;
};

struct tcp_hdr
{
	u_int16_t	source;
	u_int16_t	dest;
	u_int32_t	seq;
	u_int32_t	ack_seq;
#if __BYTE_ORDER == __LITTLE_ENDIAN
	u_int16_t	res1:4;
	u_int16_t	doff:4;
	u_int16_t	fin:1;
	u_int16_t	syn:1;
	u_int16_t	rst:1;
	u_int16_t	psh:1;
	u_int16_t	ack:1;
	u_int16_t	urg:1;
	u_int16_t	res2:2;
#elif __BYTE_ORDER == __BIG_ENDIAN
	u_int16_t	doff:4;
	u_int16_t	res1:4;
	u_int16_t	res2:2;
	u_int16_t	urg:1;
	u_int16_t	ack:1;
	u_int16_t	psh:1;
	u_int16_t	rst:1;
	u_int16_t	syn:1;
	u_int16_t	fin:1;
#else
#error	"Please define __BYTE_ORDER to __BIG_ENDIAN or __LITTLE_ENDIAN"
#endif
	u_int16_t	window;
	u_int16_t	check;
	u_int16_t	urg_ptr;
};

#endif
