/*
 *  The Mana World
 *  Copyright (C) 2004  The Mana World Development Team
 *
 *  This file is part of The Mana World.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef NET_TMWSERV_BEINGHANDLER_H
#define NET_TMWSERV_BEINGHANDLER_H

#include "net/messagehandler.h"

namespace TmwServ {

class BeingHandler : public MessageHandler
{
    public:
        BeingHandler();

        void handleMessage(MessageIn &msg);

    private:
        void handleBeingAttackMessage(MessageIn &msg);
        void handleBeingEnterMessage(MessageIn &msg);
        void handleBeingLeaveMessage(MessageIn &msg);
        void handleBeingsMoveMessage(MessageIn &msg);
        void handleBeingsDamageMessage(MessageIn &msg);
        void handleBeingActionChangeMessage(MessageIn &msg);
        void handleBeingLooksChangeMessage(MessageIn &msg);
        void handleBeingDirChangeMessage(MessageIn &msg);
};

} // namespace TmwServ

#endif
