namespace eval finger {
    variable finger

    # Define the finger array structure so that all variables are
    # defined for the callbacks in the radiobuttons and checkbuttons.
    array set finger {
        dialog ""
        entry.user ""
        entry.server ""
	force_long_output ""
	match_args_only ""
	suppress_printing ""
	force_short_output ""
        list.reset ""
	list.clear ""
    }
}

# finger::create --
#
#   Method to create the dialog box for the finger command.
#
# Note
#
#   This dialog will not grab focus so the user can keep it open
#   and run other tkWorld dialogs.  Imagine how tedious it would be
#   if you had to close the dialog to run your command, then reopen
#   it to modify it.  By not making this a modal dialog, we do not
#   have to implement any last command saving characteristics since
#   the user can just leave the dialog open.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc finger::create { } {
    global tkWorld
    variable finger

    # Put the focus on the cksum dialog if it is already open.
    if [winfo exists $finger(dialog)] {
        switch -- [wm state $finger(dialog)] {
            normal {
                raise $finger(dialog)
            }
            withdrawn -
            iconic {
                wm deiconify $finger(dialog)
            }
        }
        focus $finger(dialog)
        return
    } else {
        set finger(dialog) [dialog::create .finger Finger]
    }
   
    # There is only one tab.
    set tab1 [tabnotebook::page [dialog::interior \
            $finger(dialog)] "Options"]


    # Use a frame to encapsulate the file selection so that the
    # frame can be centered accross the grid columns.
    set f1 [frame $tab1.f1 \
            -class TabnotebookFrame]
    label $f1.label_user \
            -text "User" \
            -width 10 \
            -anchor e
    set finger(entry.user) [entry $f1.entry_user \
            -width 20 \
            -textvariable finger::finger(user)]
    label $f1.label_server \
            -text "Server" \
            -width 10 \
            -anchor e
    set finger(entry.server) [entry $f1.entry_server \
            -width 20 \
            -textvariable finger::finger(server)]
    grid $f1.label_user $f1.entry_user \
            -padx 2 \
            -pady 2 \
            -sticky w

    grid $f1.label_server $f1.entry_server \
            -padx 2 \
            -pady 2 \
            -sticky w

    # Now build the individual checkbutton options available to
    # the user.
    set f2 [frame $tab1.f2 \
            -class TabnotebookFrame]

    checkbutton $f2.force_long_output \
            -text "Force long output format" \
	    -variable finger::finger(force_long_output) \
	    -onvalue "l" \
	    -offvalue ""
    checkbutton $f2.match_args_only \
            -text "Match arguments only on user name" \
	    -variable finger::finger(match_args_only) \
	    -onvalue "m" \
	    -offvalue ""
    checkbutton $f2.suppress_printing \
            -text "Suppress printing of the .plan file" \
	    -variable finger::finger(suppress_printing) \
	    -onvalue "p" \
	    -offvalue ""
    checkbutton $f2.force_short_output \
            -text "Force short output format" \
	    -variable finger::finger(force_short_output) \
	    -onvalue "s" \
	    -offvalue ""
    grid $f2.force_long_output \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid $f2.match_args_only \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f2.suppress_printing \
            -padx 2 \
            -pady 2 \
            -sticky w
    grid $f2.force_short_output \
            -padx 2 \
            -pady 2 \
            -sticky w
    # Build the only tab.
    pack $f1 $f2 \
            -side top \
            -fill x \
            -padx 5 \
            -pady 5 \
            -ipadx 5 \
            -ipady 5

    focus $finger(entry.user)
    # Define the lists for the reset and clear methods
    set finger(list.reset) "force_long_output match_args_only \
               suppress_printing force_short_output"
    set finger(list.clear) "user server"
}

# finger::ok --
#
#   Method to insert the command the user has created into the CC.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc finger::ok { } {
    global tkWorld
    variable finger       

    # Insert the Tcl command list in the Command Center.

    $tkWorld(cmd_center) insert insert "finger "

    # Build the command line argument.
    set cmd_arg ""
    foreach x $finger(list.reset) {
        if [string length $finger($x)] {
	    append cmd_arg $finger($x)
	}
    }
    if [string length $cmd_arg] {
       $tkWorld(cmd_center) insert insert "-$cmd_arg "
    }
    if [string length $finger(user)] {
        $tkWorld(cmd_center) insert insert "$finger(user)"
    }
    if [string length $finger(server)] {
        $tkWorld(cmd_center) insert insert "@$finger(server)"
    }

    # Activate the buttons in the toolbar for the command center.
    toolbar::group_state cmd_center active
    toolbar::button_state $toolbar::toolbar(stop) disabled
}          

# finger::reset --
#
#   Method to reset the radio and checkbuttons in the dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc finger::reset { } {
    variable finger

    # Reset all of the list elements.
    foreach x $finger(list.reset) {
        set finger($x) ""
    }
}

# finger::clear --
#
#   Method to clear entry items of their text and reset the
#   background and foreground properties.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc finger::clear { } {
    variable finger

    # Reset the data structure elements and bg/fg.
    foreach x $finger(list.clear) {
        set finger($x) ""
        $finger(entry.$x) configure -bg #ffffff -fg #000000
    }

   focus $finger(entry.user)
}

# finger::help --
#
#   Method to invoke the Finger Command Help.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc finger::help { } {
    global tkWorld

        help::create "help/finger.html" "Finger Command Help"
}        

# finger::close --
#
#   Close the dialog up.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc finger::close { } {
    variable finger 

    balloonhelp::cancel
    destroy $finger(dialog)
}

# finger::open --
#
#   Method to add a file to the file entry and move the cursor
#   index of the entry to the end.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc finger::open { } {
    variable finger

     regsub { } [file::select] {} finger(user)
    $finger(user_entry) icursor end
}            
