!
! start_time.s - illustrate use of the timer device
!
!	this file should be loaded using the -s flag; after user 
!	program has been loaded.
!
!	some versions of the gnu linker (ld) like to start SPARC programs
!	at 0x2020, others like 0x20.  If your linker likes 0x20,
!	this code won't work -- 0x20 is in the middle of the exception 
!	vectors.... usually, setting an explicit entry point forces the
!	linker to use 0x2020 as an entry point -- to do this, use the
!	-e start  option to ld
!
!
!	One word of caution.... make sure that the user level program
!		starts at location 0x20 -- or change the definition
!		MAIN

	MAIN = 0x20	! start address of the user program

	TIMER_VECTOR = 0x110
	TIMER_DEVICE = 1040 << 10
	
	TICKS = 400	! number of clock ticks before an interrupt
	SAFE = 4	! the address of a safe location in the user's
			! data segment -- the timer interrupt will
			! increment this value


	!----------------------------------------------------------------------
	! start:
	!	install a handler for the timer device
	!	start the timer
	!	then start the user program
	!
	.text
	.global start
start:
	save					
	
	! install the timer vector
	!	NOTE:	   we need to load instructions from the
	!	supervisor text space and store instructions to the
	!	supervisor text space
	!	supervisor text is address space 9 
	set	8, %r3
	set	timer_vect, %r2
	ldda	[%r2]9, %r4
	ldda	[%r2+%r3]9, %r6
	set	TIMER_VECTOR, %r2
	stda	%r4, [%r2]9
	stda	%r6, [%r2+%r3]9

	! setup for a rett that will start the user program at the
	!	address MAIN
	set	MAIN, %r17
	set	MAIN+4, %r18
	jmpl	%r17, %r0
	rett	%r18


	!----------------------------------------------------------------------
	! timer_vect:
	!	the code to be placed in the timer interrupt vector
	!
	!	this code uses a jump and link instead of a branch
	!	to avoid problems with relative addresses
	!	remember, we're going to copy this code to a different
	!	location.....
	!
	.text
	.align 8
timer_vect:
	set	timer, %l3	! 2 words
	jmpl	%l3, %r0	! 1 word
	nop			! 1 word

	!----------------------------------------------------------------------
	! timer:
	!	the timer interrupt handler
	!
	.text
timer:
	! increment a value in the user address space, so they can
	! observe the changes
	set	SAFE, %l0
	lda	[%l0]10, %l1
	inc	%l1
	sta	%l1, [%l0]10
	
	! return to the user instruction that was just about to
	! execute before the interrupt was detected
	jmpl	%r17, %r0
	rett	%r18
