!
!  $Id: random.s 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $
!
!  a 16-bit random number generator for tkisem
!
!  
! From: tshiono@cv.sony.co.jp (Toru Shiono)
!    (posted to comp.lang.tcl -- you get numbers where you can find them)
!
!set _Randseed 1
!
!proc rand {} {
!    global _Randseed
!    set _Randseed [expr $_Randseed * 1103515245 + 12345]
!    return [expr ($_Randseed >> 16) & 32767]
!}
!
!proc srand {seed} {
!    global _Randseed
!    set _Randseed $seed
!}

	! defined symbols
	mpy = 1103515245
	add = 12345

	! exported names
	.global srand, rand
	
	! global (private) variables
	.data
	.align	4
	.word	0
seed:	.word	1

	.text
	.align	8
	
	!---------------------------------------------------------------------
	! srand -- seed the random number generator
	!  -- written as an optimized leaf routine
srand:
	sethi	%hi(seed), %o1

	retl
	st	%o0, [%o1+%lo(seed)]


	.text
	.align	8
	
	!---------------------------------------------------------------------
	! rand -- return a random number
	!  -- written as an optimized leaf routine
rand:
	sethi	%hi(seed), %o1
	ld	[%o1+%lo(seed)], %o0
	set	mpy, %o2
	umul	%o0, %o2, %o0
	set	add, %o2
	add	%o0, %o2, %o0
	st	%o0, [%o1+%lo(seed)]
	retl
	srl	%o0, 16, %o0
	
	


