/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED
 = "$Id: isemReg.cpp 1.2 Mon, 11 Nov 1996 14:11:38 -0700 maccabe $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tk.h>

#include "config.h"

#include "sizedefs.h"
#include "Instruct.h"
#include "RegBlock.h"
#include "IU.h"
#include "FPU.h"

#include "globals.h"

#include <ctype.h>

char RGTypes[] = {'G','O','L','I'};


class RegisterId {
public:
    enum {
	// integer unit registers
	//
	GLOBAL0, GLOBAL1, GLOBAL2, GLOBAL3, GLOBAL4, GLOBAL5, GLOBAL6, GLOBAL7,
	OUTPUT0, OUTPUT1, OUTPUT2, OUTPUT3, OUTPUT4, OUTPUT5, OUTPUT6, OUTPUT7,
	LOCAL0, LOCAL1, LOCAL2, LOCAL3, LOCAL4, LOCAL5, LOCAL6, LOCAL7,
	INPUT0, INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, INPUT7,
	PC, nPC, PSR, Y, WIM, TBR,

	// fpu registers
	//
	FLOAT0,  FLOAT1,  FLOAT2,  FLOAT3,  FLOAT4,  FLOAT5,  FLOAT6,  FLOAT7,
	FLOAT8,  FLOAT9,  FLOAT10, FLOAT11, FLOAT12, FLOAT13, FLOAT14, FLOAT15,
	FLOAT16, FLOAT17, FLOAT18, FLOAT19, FLOAT20, FLOAT21, FLOAT22, FLOAT23,
	FLOAT24, FLOAT25, FLOAT26, FLOAT27, FLOAT28, FLOAT29, FLOAT30, FLOAT31,
	FSR,

	LAST	// end of list marker
    };
};


static
struct RegisterTableEntry {
    char*	name;
    int		id;
} RegisterTable[] = {
    { "g0", RegisterId::GLOBAL0 }, { "g1", RegisterId::GLOBAL1 },
    { "g2", RegisterId::GLOBAL2 }, { "g3", RegisterId::GLOBAL3 },
    { "g4", RegisterId::GLOBAL4 }, { "g5", RegisterId::GLOBAL5 },
    { "g6", RegisterId::GLOBAL6 }, { "g7", RegisterId::GLOBAL7 },

    { "o0", RegisterId::OUTPUT0 }, { "o1", RegisterId::OUTPUT1 },
    { "o2", RegisterId::OUTPUT2 }, { "o3", RegisterId::OUTPUT3 },
    { "o4", RegisterId::OUTPUT4 }, { "o5", RegisterId::OUTPUT5 },
    { "o6", RegisterId::OUTPUT6 }, { "o7", RegisterId::OUTPUT7 },

    { "l0", RegisterId::LOCAL0 }, { "l1", RegisterId::LOCAL1 },
    { "l2", RegisterId::LOCAL2 }, { "l3", RegisterId::LOCAL3 },
    { "l4", RegisterId::LOCAL4 }, { "l5", RegisterId::LOCAL5 },
    { "l6", RegisterId::LOCAL6 }, { "l7", RegisterId::LOCAL7 },

    { "i0", RegisterId::INPUT0 }, { "i1", RegisterId::INPUT1 },
    { "i2", RegisterId::INPUT2 }, { "i3", RegisterId::INPUT3 },
    { "i4", RegisterId::INPUT4 }, { "i5", RegisterId::INPUT5 },
    { "i6", RegisterId::INPUT6 }, { "i7", RegisterId::INPUT7 },

    { "r0", RegisterId::GLOBAL0 }, { "r1", RegisterId::GLOBAL1 },
    { "r2", RegisterId::GLOBAL2 }, { "r3", RegisterId::GLOBAL3 },
    { "r4", RegisterId::GLOBAL4 }, { "r5", RegisterId::GLOBAL5 },
    { "r6", RegisterId::GLOBAL6 }, { "r7", RegisterId::GLOBAL7 },

    { "r8", RegisterId::OUTPUT0 }, { "r9", RegisterId::OUTPUT1 },
    { "r10", RegisterId::OUTPUT2 }, { "r11", RegisterId::OUTPUT3 },
    { "r12", RegisterId::OUTPUT4 }, { "r13", RegisterId::OUTPUT5 },
    { "r14", RegisterId::OUTPUT6 }, { "r15", RegisterId::OUTPUT7 },

    { "r16", RegisterId::LOCAL0 }, { "r17", RegisterId::LOCAL1 },
    { "r18", RegisterId::LOCAL2 }, { "r19", RegisterId::LOCAL3 },
    { "r20", RegisterId::LOCAL4 }, { "r21", RegisterId::LOCAL5 },
    { "r22", RegisterId::LOCAL6 }, { "r23", RegisterId::LOCAL7 },

    { "r24", RegisterId::INPUT0 }, { "r25", RegisterId::INPUT1 },
    { "r26", RegisterId::INPUT2 }, { "r27", RegisterId::INPUT3 },
    { "r28", RegisterId::INPUT4 }, { "r29", RegisterId::INPUT5 },
    { "r30", RegisterId::INPUT6 }, { "r31", RegisterId::INPUT7 },

    { "pc", RegisterId::PC }, { "npc", RegisterId::nPC },
    { "psr", RegisterId::PSR },  { "y",  RegisterId::Y },
    { "wim", RegisterId::WIM }, { "tbr", RegisterId::TBR },

    { "f0", RegisterId::FLOAT0 }, { "f1",  RegisterId::FLOAT1 },
    { "f2", RegisterId::FLOAT2 }, { "f3",  RegisterId::FLOAT3 },
    { "f4", RegisterId::FLOAT4 }, { "f5",  RegisterId::FLOAT5 },
    { "f6", RegisterId::FLOAT6 }, { "f7",  RegisterId::FLOAT7 },

    { "f8", RegisterId::FLOAT8 }, { "f9",  RegisterId::FLOAT9 },
    { "f10", RegisterId::FLOAT10 }, { "f11", RegisterId::FLOAT11 },
    { "f12", RegisterId::FLOAT12 }, { "f13", RegisterId::FLOAT13 },
    { "f14", RegisterId::FLOAT14 }, { "f15", RegisterId::FLOAT15 },

    { "f16", RegisterId::FLOAT16 }, { "f17", RegisterId::FLOAT17 },
    { "f18", RegisterId::FLOAT18 }, { "f19", RegisterId::FLOAT19 },
    { "f20", RegisterId::FLOAT20 }, { "f21", RegisterId::FLOAT21 },
    { "f22", RegisterId::FLOAT22 }, { "f23", RegisterId::FLOAT23 },

    { "f24", RegisterId::FLOAT24 }, { "f25", RegisterId::FLOAT25 },
    { "f26", RegisterId::FLOAT26 }, { "f27", RegisterId::FLOAT27 },
    { "f28", RegisterId::FLOAT28 }, { "f29", RegisterId::FLOAT29 },
    { "f30", RegisterId::FLOAT30 }, { "f31", RegisterId::FLOAT31 },

    { "fsr", RegisterId::FSR }
};

static const
int RegisterTableLength = sizeof(RegisterTable) / sizeof(RegisterTableEntry);


Float_s FRegVal_s(int regid) {
    return fpu->freg( regid - RegisterId::FLOAT0 );
}

Float_d FRegVal_d(int regid) {
    return fpu->dreg( (regid - RegisterId::FLOAT0) & 0x1e );
}

UInt32 RegVal(int regid) {
    if (regid < 32)		// handle integer unit data registers
	return (*RB)[regid];

    switch (regid) {
    case RegisterId::PC:
        return iu->PC();
    case RegisterId::nPC:
        return iu->nPC();
    case RegisterId::PSR:
        return iu->PSR();
    case RegisterId::Y:
        return iu->Y();
    case RegisterId::WIM:
        return iu->WIM();
    case RegisterId::TBR:
        return iu->TBR();
    case RegisterId::FSR:
        return fpu->FSR();
    default:
        Assert(0, "unknown special register: PLEASE EMAIL isem@cs.unm.edu with this error!");
    }
}

static int xlatregid(char* regname) {
    if( *regname == '%' ) {
	regname++;
    }

    for (int i = 0; i < RegisterTableLength; i++) {
	if (strcmp(regname, RegisterTable[i].name) == 0)
	    return RegisterTable[i].id;
    }

    return -1;
}

int Isem_Reg( ClientData, Tcl_Interp *interp, int argc, char *argv[] ) {
    //
    // usage:
    //    isem_reg ( set | get ) register [ vlaue ]
    //

    if( argc < 3 || ((strcmp(argv[1],"get")==0) && argc != 3)
	|| ((strcmp(argv[1],"set")==0) && argc != 4) ) {
	sprintf( interp->result, "isem_reg:  invalid number of arguments: %d",
		 argc );
	return TCL_ERROR;
    }

    int regid = xlatregid( argv[2] );

    if (regid < 0 || regid >= RegisterId::LAST) {
	sprintf( interp->result, "isem_reg:  unknown register '%s'", argv[2] );
        return TCL_ERROR;
    }

    if( strcmp(argv[1],"get") == 0 ) {
	if ( regid >= RegisterId::FLOAT0 && regid <= RegisterId::FLOAT31 ) {
#ifdef LATER
	    if (opt == DOUBLE_OPTION)
	      UiDispMsg(FRegVal_d(regid));
	    else
	      UiDispMsg(FRegVal_s(regid));
#endif
	} else{
	    sprintf( interp->result, "0x%.8x", RegVal(regid) );
	}
    } else {
	UInt32 value;
	value = strtoul( argv[3], 0, 0);
	if (regid < 32) {  // handle integer unit data registers
	    (*RB)[regid] = value;
	} else {
	    switch (regid) {
	    case RegisterId::PC:
		iu->PC(value);
		break;
	    case RegisterId::nPC:
		strcpy( interp->result, "nPC cannot be modified by the user");
		return TCL_ERROR;
	    case RegisterId::PSR:
		iu->PSR(value);
		break;
	    case RegisterId::Y:
		iu->Y(value);
		break;
	    case RegisterId::WIM:
		iu->WIM(value);
		break;
	    case RegisterId::TBR:
		iu->TBR(value);
		break;
	    }
	}
	sprintf( interp->result, "0x%.8x", RegVal(regid) );
    }
    return TCL_OK;
}
