#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */

#   if defined(_MSC_VER)
#	define EXPORT(a,b) __declspec(dllexport) a b
#	define DllEntryPoint DllMain
#   else
#	if defined(__BORLANDC__)
#	    define EXPORT(a,b) a _export b
#	else
#	    define EXPORT(a,b) a b
#	endif
#   endif
#else
#   define EXPORT(a,b) a b
#endif


extern "C" {
EXTERN EXPORT(int,Tkisem_Init) _ANSI_ARGS_((Tcl_Interp *interp));
}

extern int user_steps, user_mems, super_steps, super_mems;

Tcl_CmdProc Isem_Load;
Tcl_CmdProc Isem_Disasm;

Tcl_CmdProc Isem_Step;
Tcl_CmdProc Isem_Interp;
Tcl_CmdProc Isem_Poll;
Tcl_CmdProc Isem_Usteps;
Tcl_CmdProc Isem_Tsteps;
Tcl_CmdProc Isem_Counts;

Tcl_CmdProc Isem_Annul;
Tcl_CmdProc Isem_Dev;
Tcl_CmdProc Isem_GX;
Tcl_CmdProc Isem_Reg;
Tcl_CmdProc Isem_Mem_Rd;
Tcl_CmdProc Isem_Mem_Wr;
Tcl_CmdProc Isem_Inter;
