/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: shift.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

//-----------------------------------------------------------------------
// Shift Instructions - see p172 of SPARC Architecture Manual, Version 8
//-----------------------------------------------------------------------

#include "Assert.h"
#include "sizedefs.h"
#include "Instruct.h"
#include "RegBlock.h"
#include "IU.h"

void IntegerUnit::shift(const Instruction& inst) {
    UInt32 rs1 = inst.rs1(); 
    UInt32 rd  = inst.rd();

    UInt32 shift_count = (inst.i() == 0) ? reg[inst.rs2()] & 0x1F :inst.shcnt();

    switch ( inst.op3() ) {
    case Instruction::SLL:
        reg[rd] = reg[rs1] << shift_count;
	break;

    case Instruction::SRL:
        reg[rd] = reg[rs1] >> shift_count;
	break;

    case Instruction::SRA:
        if (reg[rs1] & 0x80000000) {
	    reg[rd] = (reg[rs1] >> shift_count) | 
                      (0xffffffff << (32 - shift_count));
        } 
        else { 
	    reg[rd] = reg[rs1] >> shift_count; 
        }
        break;

    default:
	Assert(0, "Unknown op3: PLEASE EMAIL isem@cs.unm.edu with this error!");
    }
}
