/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//
// $Id: Config.h 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $
//

//
// Config.h - all system configuration parameters are set here.
//	      The parameters are encapsulated in a class in order
//	      keep a more sane name space
//

//
// A page is 1024 words or 4096 bytes
//
//
// Here is the memory page map
// 
// memory is in pages:
//    0000/4 = 000
// thru
//    1020/4 = 255
//
// the GX device occupies pages:
//    1024/4 = 256
//    1028/4 = 257
//    1032/4 = 258
//    1036/4 = 259


#ifndef _CONFIG_H_
#define _CONFIG_H_

class Config {
public:
    enum {
	NWINDOWS	= 4,			// number of register windows
	ADDR_BITS	= 24,			// size of phys addr space

	ISEM_PAGE_BITS	= 12,			
	ISEM_PAGE_SIZE	= 4096,

	PHYS_MEM_SIZE	= 1024,			// in 1K units
	PHYS_MEM_START	= 0,			// in 1K units

	GX_START	= 1024,			// in 1K units

	LAST_CONFIG	= 0
    };
};

#endif
