/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//----------------------------------------------------------------------
// convert_itof instruction - see page 141 of SPARC Architecture Manual,
//				              Version 8
//----------------------------------------------------------------------

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: cvt_itof.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

#include "Assert.h"
#include "sizedefs.h"
#include "Instruct.h"
#include "IU.h"
#include "FPU.h"

// NEED --
// rounding should be according to _RD field of FSR -- _RD
// field set (and rounding set) by call to RD modify function.
// fp_exception -- NX (FiTOs only)  ???
//       -- invalid_fp_register (FiTOd, FiTOq)

int FloatingPointUnit::convert_itof(const Instruction& inst) { 
    switch (inst.opf()){
    case FiTOs:
	_freg[inst.rd()] = (Float_s)_ireg[inst.rs2()];
	break;

    case FiTOd:
	if (inst.rd() & 1) {
	   _ftt = invalid_fp_register;
	   return IntegerUnit::fp_exception;
	}

        _dreg[inst.rd()] = (Float_d)_ireg[inst.rs2()];
	break;

    case FiTOq:
	_ftt = unimplemented_FPop;
	return unimplemented();

    default:
        Assert(0, "unknown opf: PLEASE EMAIL isem@cs.unm.edu with this error!");
    }

    _ftt = No_FPU_Trap;
    return 0;
}
