#   Copyright (C) 1987-2005 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Wed Apr 19 17:05:18 2000
#

#
# List of ttys
#
set tkg_ttylist {}

image create bitmap txtcurs -file "$bd/txtcurs.b"

proc tkg_mktty {n} {
  global tkg_ttys tkg_ttygat tkg_ttylist

  set i 0
  set w ""

  while { [catch { set w [toplevel .tty$i] }] } {
    incr i
  }

  set tkg_ttys($n) $w
  set tkg_ttygat($w) $n
  lappend tkg_ttylist $w

  wm resizable $w 0 0
  wm title $w "TkGate: TTY $n"
  wm geometry $w [offsetgeometry . [expr 50 * ( $i + 1 )] [expr 50 * ( $i + 1 )]]

  text $w.txt -state disabled
  pack $w.txt
  $w.txt image create end -image txtcurs

  bind $w <KeyPress> " if { \[string length %A \] > 0 } { scan %A %%c c; tkg_simWrite \"command $tkg_ttygat($w) key \$c\" } "
}

proc tkg_rmttys {} {
  global tkg_ttys tkg_ttygat tkg_ttylist

  catch {
    unset tkg_ttys
    unset tkg_ttygat
    foreach t $tkg_ttylist {
      destroy $t
    }
  }
}

proc tkg_ttyChar {n c} {
  global tkg_ttys

  set w $tkg_ttys($n)

  if { $c == 7 } {
    bell
    return
  } elseif { $c == 127 } {
    $w.txt configure -state normal
    $w.txt delete "end - 3 chars"
    $w.txt see end
    $w.txt configure -state disabled
    return
  }

  set x [format %c $c]

  $w.txt configure -state normal
  $w.txt insert "end - 2 chars" $x
  $w.txt see end
  $w.txt configure -state disabled
}
