/****************************************************************************
    Copyright (C) 1987-2004 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Thu Jun 22 20:27:17 2000
****************************************************************************/
#include "tkgate.h"

static iconDimensions ground_iconDims[] = {
  {0, 0, 11, 11, 5, 5},
};
static int ground_iconBoldOffset = 12;

struct locate ground_out_loc[] = {{0,-6,0,-6,D_UP}};

static char *psGround[] = {
  "%",
  "% x y r ground",
  "%",
  "/psground {",
  "  startgate",
  "  -4 6 moveto 4 6 lineto stroke",
  "  -3 4 moveto 3 4 lineto stroke",
  "  -2 2 moveto 2 2 lineto stroke",
  "  -1 0 moveto 1 0 lineto stroke",
  "  grestore",
  "} def",
  0
};

GGateInfo gate_ground_info = {
  0,
  "Ground",
  "supply0",0x0,
  "psground",psGround,

  {{"g",	{"gmswitch",0},		{"gmground",0,0,300},	"gat_make supply0"},
   {0}},

  ground_iconDims,

  1,{{"Z",OUT,1,1,ground_out_loc}},
  {{5,15,LJ},{5,15,LJ},{5,15,LJ},{5,15,LJ}},
  {0,1,1},

  {0},

  Generic_Make,
  Generic_Init,
  Generic_Delete,
  Generic_GetExtents,
  Generic_HitDistance,
  Generic_Draw,
  Generic_Move,
  Generic_Replicate,
  Err_AddInput,
  Err_AddOutput,
  Err_AddInOut,
  Err_ChangePin,
  Nop_SimStateFunc,
  Nop_SimHitFunc,
  Generic_PSWrite,
  Generic_EditProps,
  InOut_VerSave
};

void init_ground()
{
  Pixmap P;

  P = Pixmap_registerFromFile("ground","ground.b");
  gateinfo_1iconInit(&gate_ground_info,P,ground_iconDims,ground_iconBoldOffset);
  RegisterGate(&gate_ground_info);
}
