#   Copyright (C) 1987-2004 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Fri Dec  5 12:31:19 2003
#
# This file contains procedures for displaying and maniuplating
# the error list.  The error list is a box listing any errors that
# occured when starting the simulator.  The user can click on an
# error messsage and cause the editor to jump to the location
# of the error.
#
# tkg_makeErrBox			Pop up the error message box
# tkg_delErrBox				Delete the error box
# tkg_errBoxAdd "error message"		Add a message to the box
#
# tkg_errBoxReport			Call back to report selection
# gat_errBoxReport			C call back
#

set tkg_errBoxActive 0

proc tkg_errBoxReport {} {
  action ShowErr {
    gat_errBoxReport [.errbox.lframe.list curselection]
  }
}

proc tkg_delErrBox {} {
  global tkg_errBoxActive
  set tkg_errBoxActive 0
  transAction - {
    gat_errBoxReport -1
  }
  destroy .errbox
}

proc tkg_errBoxUp {} {

  if { [catch {set N [.errbox.lframe.list curselection]} ] } {
    return
  } 


  if { $N == "" } {
    set N 0
  } else {
    set N [expr $N - 1]
  }
  .errbox.lframe.list selection clear 0 end
  .errbox.lframe.list selection set $N
  .errbox.lframe.list see $N
  tkg_errBoxReport
}

proc tkg_errBoxDown {} {
  if { [catch {set N [.errbox.lframe.list curselection]} ] } {
    return
  } 

  if { $N == "" } {
    set N 0
  } else {
    set N [expr $N + 1]
  }
  .errbox.lframe.list selection clear 0 end
  .errbox.lframe.list selection set $N
  .errbox.lframe.list see $N
  tkg_errBoxReport
}


proc tkg_makeErrBox {} {
  global tkg_errBoxActive

  toplevel .errbox
  wm title .errbox "TKGate: Error List"
  wm transient .errbox .

  frame .errbox.lframe

  listbox .errbox.lframe.list -width 60 -yscrollcommand ".errbox.lframe.vert set" -xscrollcommand ".errbox.lframe.horz set"
  scrollbar .errbox.lframe.vert -command ".errbox.lframe.list yview"
  scrollbar .errbox.lframe.horz -orient horizontal -command ".errbox.lframe.list xview"

  grid rowconfigure .errbox.lframe 0 -weight 0
  grid columnconfigure .errbox.lframe 0 -weight 0
  grid .errbox.lframe.list -row 0 -column 0 -sticky nsew 
  grid .errbox.lframe.vert -row 0 -column 1 -sticky ns 
  grid .errbox.lframe.horz -row 1 -column 0 -sticky ew 

  pack .errbox.lframe -side top  -padx 5 -pady 5 -fill both -expand 1

  bind .errbox.lframe.list <ButtonRelease-1> { tkg_errBoxReport }

  frame .errbox.dframe
  button .errbox.dframe.dismiss -text [m b.dismiss] -command tkg_delErrBox
  pack .errbox.dframe.dismiss -fill both -padx 5 -pady 5
  pack .errbox.dframe -side bottom  -padx 5 -pady 5


  bind .errbox <Up>		{ act_errBoxUp }
  bind .errbox <Down>		{ act_errBoxDown }
  bind .errbox <p>		{ act_errBoxUp }
  bind .errbox <n>		{ act_errBoxDown }
  bind .errbox <Control-p>	{ act_errBoxUp }
  bind .errbox <Control-n>	{ act_errBoxDown }

  set tkg_errBoxActive 1
}

proc tkg_errBoxAdd args {
  .errbox.lframe.list insert end [join $args ]
}

proc tkg_errBoxTestSetup {} {
  global tkg_errBoxActive
  if { $tkg_errBoxActive == 0 } {
    tkg_makeErrBox
    tkg_errBoxAdd "This is an error message of some length with an \"h\" in it."
    tkg_errBoxAdd how
    tkg_errBoxAdd are
    tkg_errBoxAdd you
    tkg_errBoxAdd world
  }
}

proc tkg_errBoxTest {} {
  button .open -text [m b.open] -command tkg_errBoxTestSetup
  pack .open
}



