/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "gsim.h"

#define PMOS_Z	0
#define PMOS_I	1
#define PMOS_G	2

#define PMOS_DELAY_ID 0
#define PMOS_DELAY_GD 1

static void Pmos_processEvent(SGate*,EvQueue*,SEvent*);
int Mos_checkGate(SGate*g);

static SGateInfo pmos_info = {
  0,
  "pmos",0x0,
  3,{{"Z",GIO_TRI,0},
     {"I",GIO_IN,0},
     {"G",GIO_IN,0}},

  {{"I-Z",bit(1),0},{"G-Z",bit(2),0},0},

  Generic_copyGate,
  Pmos_processEvent,
  Mos_checkGate,
  Nop_initGate,
  0,
  0,
  0,
  Generic_propFrwdDelay,
  Generic_propBackDelay,
  Generic_delay,
};

void init_pmos()
{
  SGateInfo_register(&pmos_info,0);
}


static void Pmos_processEvent(SGate *g,EvQueue *Q,SEvent *E)
{
  SPort *Z = g->g_ports.port[PMOS_Z];
  SState *S = alloc_SState();
  SState *I = SGate_allocPortState(g,PMOS_I);
  SState *G = SGate_allocPortState(g,PMOS_G);
  int delay;

  if (IsChangeOn(E,g,PMOS_I))
    delay = g->g_delayParms[PMOS_DELAY_ID];
  else
    delay = g->g_delayParms[PMOS_DELAY_GD];

  SState_reinit(S,Z->p_state.nbits);
  SState_pmos(S,I,G);

  EvQueue_setPort(Q,Z,S,delay);

  free_SState(S);
  free_SState(I);
  free_SState(G);
}
