#   Copyright (C) 1987-2001 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Thu Nov 16 10:37:27 2000
#
set cms_status 0

######################################################################
#
# Display a simple error message with an OK button to dismiss
#
proc errmsg {msg} {
  tk_messageBox -default ok -icon error -type ok -message $msg
}

proc tkScreenChanged args {
#  puts "tkScreenChanged $args"
}

proc confirmMsg {msg} {
  global msg_font cms_status

  set cms_status 0

  set result [tk_messageBox -default ok -icon question -type okcancel -message $msg]

  if { "$result" == "ok" } { set cms_status 1 }

  return $cms_status
}

proc tkg_verilogErr {fn msg} {
  if { ! [catch { toplevel .vererr }] } {
    scan [winfo pointerxy .] "%d %d" X Y
    wm geometry .vererr +[expr $X + 5]+[expr $Y + 5]
    wm transient .vererr .

    label .vererr.l -text "[m err.verilog] $fn: "

    frame .vererr.f
    text .vererr.f.t -yscrollcommand ".vererr.f.sb set"
    scrollbar .vererr.f.sb -command ".vererr.f.t yview" -takefocus 0
    pack .vererr.f.t .vererr.f.sb  -side left -fill y

    button .vererr.d -text [m b.dismiss] -command { destroy .vererr }
    pack .vererr.l -padx 5 -pady 5
    pack .vererr.f -padx 5 -pady 5
    pack .vererr.d -padx 5 -pady 5
  }
  .vererr.f.t insert end $msg
  .vererr.f.t insert end "\n"
}

#
# Post a message which lasts only as long as the mouse is depressed
#
proc tkg_tempMessage {msg} {
  global boldBody_font

  scan [winfo pointerxy .] "%d %d" x y

  catch { destroy .tempmsg }
  toplevel .tempmsg -bg bisque

  wm geometry .tempmsg +[expr $x + 5]+[expr $y - 30]
  wm transient .tempmsg .
  wm overrideredirect .tempmsg 1

  label .tempmsg.l -text $msg -bg bisque -justify left -font $boldBody_font
  pack .tempmsg.l -padx 4 -pady 4
}

proc tkg_hideTempMessage {} {
  catch { destroy .tempmsg }
}

