## This plugin sends WinPop messages to machines if they
## support the winpop protocol.
##
## Ethan Gold <etgold@cs.vassar.edu> 2/27/98
##

if {[debug]} { puts "loading Winpop plugin..." }

## register the plugin
register_plugin smb winpop WinPop

#### required procedures that simply return plugin information
proc winpop.geticon {} { return "winpop.pnm" }
proc winpop.getpubname {} { return "WinPop" }
proc winpop.getprotocol {} { return "smb" }

#### real plugin functionality below here##

########## required functions #################

## start function - required
proc winpop.start {} {
    if {[debug]} { puts "started Winpop Plugin" }

    set entlabel [plug_list_label]
    $entlabel configure -text "WinPop Suckers:"
    update
    winpop.widgets stop
    winpop.widgets start
    winpop.newzone
}

## stop funtion - required
proc winpop.stop {} {
    if {[debug]} { puts "stopped WinPop Plugin" }
    smb.delmachines
    set ID [get_glob afterID]
    if {[string compare $ID ""] != 0 } {
	after cancel $ID
    }
    winpop.widgets stop
}

## function to call when a listitem is double-clicked
proc winpop.doubleclick {} {
    if {[debug]} { puts "winpop: got double-click with [get_curr_item]" }
    winpop.compose [get_curr_item] [smb.getcurrzone]
}

proc winpop.newzone {} {
    smb.setmachines
    #set plugframe [plug_frame]
    #$plugframe.status configure -text "scanning [smb.getcurrzone]..."
    #update
    #winpop.clearentities
    #$plugframe.status configure -text "ready."
}

############# End required functions ##################

## procedure to build and destroy winpop widgets
proc winpop.widgets {command} {
    global plug_globflat
    set plugframe [plug_frame]
    if {[string compare $command "start"] == 0} {
	button $plugframe.send -text "Send..." \
		-command {winpop.compose [get_curr_item] "WORKGROUP"}
	#-command "winpop.compose \"\[get_curr_item\]\" \"WORKGROUP\""

	pack $plugframe.send
    } else {
	destroy $plugframe.send
    }
    
}

## procedure to compose a message to a machine
proc winpop.compose {machine zone} {
    set propfont [get_propfont]
    set w .winpopoutgoing
    toplevel $w
    #set newx [expr 300 + $x % 20]
    #set newy [expr 300 + $y % 20]
    #wm geometry $w +$newx+$newy

    scrollbar $w.scroll -command "$w.message yview"
    text $w.message -width 50 -height 5 -wrap word \
	    -yscrollcommand "$w.scroll set" -font $propfont
    entry $w.machine -width 15 -textvariable machine
    button $w.send -text "Send" \
	    -command "winpop.send $machine $zone \[$w.message get 0.0 end\]; $w.cancel invoke"

    button $w.cancel -text "Cancel" -command "destroy $w"

    button $w.include -text "insert file" \
	    -command "fileselect winpop.setmesgcontents"

    pack $w.scroll -side left -fill y -pady 1m
    pack $w.message -expand 1 -fill both
    pack $w.send -side right
    pack $w.cancel -side right
    pack $w.include -side right

    focus $w.message

    bind $w.message <KP_Enter> "$w.send invoke"
    bind $w.message <Control-c> "$w.cancel invoke"
    bind $w.message <Control-w> "$w.cancel invoke"
}


## function to return the contents of a file
proc winpop.setmesgcontents {file} {
    if { [catch {set infd [open $file r]}] } {
	error "could not open $file"
    } else {
	while { [gets $infd line] >= 0 } {
	    .winpopoutgoing.message insert end "$line\n"
	}
    }
}


## procedure to send the message via smbclient
proc winpop.send {machine zone message} {
    if {[debug]} { puts "winpop: send called with $machine, $zone, $message" }
    if {[string compare $machine ""] == 0} {
	error "winpop" "please choose a receipient"
	return
    }

    ## write the message to a temp file
    set outfdname "/tmp/winpop.[clock seconds]"
    puts "winpop: outfdname: $outfdname"
    set outfd [open $outfdname w]
    puts $outfd "$message"
    close $outfd
    
    set tmperr "/tmp/winpop.err.[clock seconds]"
    ## send message
    catch {exec cat $outfdname | smbclient -M $machine >& $tmperr &}
    
    after 1000
    set errfd [open $tmperr r]
    while {[gets $errfd line] != -1} {
	if {[debug]} {puts "winpop: errline: $line"}
	if {[regexp {.*ERRSRV.*} $line]} { error "Winpop" "$line" }
    }
    close $errfd
    
    ## delete temp file
    after 10000 "file delete -force $outfdname; file delete -force $tmperr"
}


proc winpop.showentities {entitylist} {
    set lbox [plug_list]
    foreach entity $entitylist {
	$lbox insert end $entity
    }
}

proc winpop.clearentities {} {
    set lbox [plug_list]
    $lbox delete 0 end
}



if {[debug]} { puts "finished loading Winpop plugin." }

