# $Id: socks5.tcl,v 1.2 2004/07/01 21:39:12 aleksey Exp $

namespace eval socks5 {}
namespace eval socks5::target {}
namespace eval socks5::initiator {}

set ::NS(bytestreams) http://jabber.org/protocol/bytestreams

proc socks5::target::sock_connect {connid jid sid hosts} {
    variable connection

    foreach host $hosts {
	lassign $host addr port streamhost
	debugmsg si "CONNECTING TO $addr:$port..."
	if {[catch {set sock [socket -async $addr $port]}]} continue
	debugmsg si "CONNECTED"
	fconfigure $sock -translation binary -blocking no
	set connection(sock,$sid) $sock

	puts -nonewline $sock "\x05\x01\x00"
	flush $sock
	fileevent $sock readable \
	    [list [namespace current]::wait_for_method $sock $connid $jid $sid]

	vwait [namespace current]::connection(status,$sid)

	if {$connection(status,$sid) == 0} continue

	set res [jlib::wrapper:createtag query \
		     -vars [list xmlns $::NS(bytestreams)] \
	     -subtags [list \
			   [jlib::wrapper:createtag streamhost-used \
				-vars [list jid $streamhost]]]]

	return [list result $res]
    }

    debugmsg si "FAILED"

    return [list error cancel item-not-found]
}

proc socks5::target::wait_for_method {sock connid jid sid} {
    variable connection
    if {[catch {set data [read $sock]}]} {
	::close $sock
	set connection(status,$sid) 0
	return
    }

    if {[eof $sock]} {
	set connection(status,$sid) 0
	return
    }

    binary scan $data cc ver method

    if {$ver != 5 || $method != 0} {
	::close $sock
	set connection(status,$sid) 0
	return
    }

    set myjid [jlib::connection_jid $connid]
    set hash [::sha1::sha1 $sid$jid$myjid]

    set len [binary format c [string length $hash]]

    puts -nonewline $sock "\x05\x01\x00\x03$len$hash\x00\x00"
    flush $sock

    fileevent $sock readable \
	[list [namespace current]::wait_for_reply $sock $jid $sid]

}

proc socks5::target::wait_for_reply {sock jid sid} {
    variable connection
    if {[catch {set data [read $sock]}]} {
	::close $sock
	set connection(status,$sid) 0
	return
    }

    if {[eof $sock]} {
	set connection(status,$sid) 0
	return
    }

    binary scan $data cc ver rep

    if {$ver != 5 || $rep != 0} {
	::close $sock
	set connection(status,$sid) 0
	return
    }

    set connection(status,$sid) 1
    fileevent $sock readable \
	[list [namespace parent]::readable $sid $sock]
}

proc socks5::target::send_data {sid data} {
    variable connection

    puts -nonewline $connection(sock,$sid) $data
    flush $connection(sock,$sid)

    return 1
}

proc socks5::target::close {sid} {
    variable connection
    ::close $connection(sock,$sid)
}


proc socks5::initiator::connect {connid jid sid} {
    variable connection
    variable hash_sid

    set_status [::msgcat::mc "Opening SOCKS5 listening socket"]

    set servsock [socket -server [list [namespace current]::accept $sid] 0]
    lassign [fconfigure $servsock -sockname] addr hostname port
    set ip [lindex [fconfigure $jlib::lib($connid,sck) -sockname] 0]
    set myjid [jlib::connection_jid $connid]
    set hash [::sha1::sha1 $sid$myjid$jid]
    set hash_sid($hash) $sid

    jlib::send_iq set \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns $::NS(bytestreams) \
			sid $sid] \
	     -subtags [list \
			   [jlib::wrapper:createtag streamhost \
				-vars [list jid $myjid \
					   host $ip \
					   port $port]]]] \
	-to $jid \
	-command [list [namespace current]::recv_connect_response \
		      $connid $jid $sid] \
	-connection $connid

    vwait [namespace current]::connection(status,$sid)
    return $connection(status,$sid)
}

proc socks5::initiator::recv_connect_response {connid jid sid res child} {
    variable connection

    if {$res != "OK"} {
	set connection(status,$sid) [list 0 [error_to_string $child]]
	return
    }

    # TODO
    set connection(status,$sid) 1
    return
}

proc socks5::initiator::send_data {sid data} {
    variable connection

    puts -nonewline $connection(sock,$sid) $data
    flush $connection(sock,$sid)

    return 1
}

proc socks5::initiator::close {sid} {
    variable connection
    ::close $connection(sock,$sid)
}

proc socks5::initiator::accept {sid sock addr port} {
    variable connection

    debugmsg si "CONNECT FROM $addr:$port"

    set connection(sock,$sid) $sock
    fconfigure $sock -translation binary -blocking no

    fileevent $sock readable \
	[list [namespace current]::wait_for_methods $sock $sid]
}

proc socks5::initiator::wait_for_methods {sock sid} {
    variable connection
    if {[catch {set data [read $sock]}]} {
	::close $sock
	set connection(status,$sid) 0
	return
    }

    if {[eof $sock]} {
	set connection(status,$sid) 0
	return
    }

    binary scan $data ccc* ver nmethods methods

    if {$ver != 5 || ![lcontain $methods 0]} {
	puts -nonewline $sock "\x05\xff"
	::close $sock
	set connection(status,$sid) 0
	return
    }

    puts -nonewline $sock "\x05\x00"
    flush $sock

    fileevent $sock readable \
	[list [namespace current]::wait_for_request $sock $sid]
}

proc socks5::initiator::wait_for_request {sock sid} {
    variable connection
    variable hash_sid

    if {[catch {set data [read $sock]}]} {
	::close $sock
	set connection(status,$sid) 0
	return
    }

    if {[eof $sock]} {
	set connection(status,$sid) 0
	return
    }

    binary scan $data ccccc ver cmd rsv atyp len

    if {$ver != 5 || $cmd != 1 || $atyp != 3} {
	set reply [string replace $data 1 1 \x07]
	puts -nonewline $sock $reply
	::close $sock
	set connection(status,$sid) 0
	return
    }

    binary scan $data @5a${len} hash

    debugmsg si "RECV HASH: $hash"

    if {[info exists hash_sid($hash)] && \
	    [string equal $hash_sid($hash) $sid]} {
	set reply [string replace $data 1 1 \x00]
	puts -nonewline $sock $reply
	flush $sock

	fileevent $sock readable {}
    } else {
	set reply [string replace $data 1 1 \x02]
	puts -nonewline $sock $reply
	::close $sock
	set connection(status,$sid) 0
    }
}

proc socks5::readable {sid chan} {
    if {![eof $chan]} {
	set buf [read $chan 4096]
	si::recv_data $sid $buf
    } else {
	fileevent $chan readable {}
	si::closed $sid
    }
}

proc socks5::iq_set_handler {connid from child} {
    jlib::wrapper:splitxml $child tag vars isempty chdata children

    if {$tag == "query"} {
	set sid [jlib::wrapper:getattr $vars sid]

	set hosts {}
	foreach item $children {
	    jlib::wrapper:splitxml $item tag1 vars1 isempty1 chdata1 children1
	    switch -- $tag1 {
		streamhost {
		    lappend hosts [list [jlib::wrapper:getattr $vars1 host] \
				       [jlib::wrapper:getattr $vars1 port] \
				       [jlib::wrapper:getattr $vars1 jid]]
		}
	    }
	}

	debugmsg si [list $hosts]
	[namespace current]::target::sock_connect $connid $from $sid $hosts
    } else {
	return [list error modify bad-request]
    }
}

iq::register_handler set "" $::NS(bytestreams) \
    [namespace current]::socks5::iq_set_handler

si::register_transport $::NS(bytestreams) $::NS(bytestreams) 50 \
    [namespace current]::socks5::initiator::connect \
    [namespace current]::socks5::initiator::send_data \
    [namespace current]::socks5::initiator::close

