/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "outputcontrol.h"
#include "ConfigFile.H"
#include "main.h"
#include <wx/config.h>
#include <wx/settings.h>
#include <wx/txtstrm.h>
#include <wx/wfstream.h>

BEGIN_EVENT_TABLE(TtOutputControl, wxTextCtrl)
  EVT_SET_FOCUS(TtOutputControl::onSetFocus)
  EVT_MOUSE_EVENTS(TtOutputControl::onMouse)
END_EVENT_TABLE()

TtOutputControl::TtOutputControl (wxWindow *parent)
  : wxTextCtrl(parent, 5, _T(""), wxDefaultPosition, wxDefaultSize,
	       wxNO_BORDER|wxTE_MULTILINE|wxTE_NOHIDESEL|wxTE_DONTWRAP|wxTE_READONLY|wxTE_RICH2),
    localfont(0),
    highlightCharPos(-1)
{
  textcolor = new wxColor(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWTEXT));
  bgcolor = new wxColor(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW));
  wxFont f = TtConfigFile::getPtr()->getMainWindowFont();
  setFont(f);
}

TtOutputControl::~TtOutputControl () {
}

/* This control is not allowed to have the focus!
 */
void TtOutputControl::onSetFocus (wxFocusEvent& event) {
  // no event skip
}
void TtOutputControl::onMouse (wxMouseEvent& event) {
  // no event skip
}

void TtOutputControl::updateLook () {
  wxTextAttr attribs(*(this->textcolor),
		     *(this->bgcolor),
		     *(this->localfont));
  SetDefaultStyle(attribs);
  SetStyle(0,GetLastPosition(),attribs);
  highlightChar();
}

#include "commonElements.H"

void TtOutputControl::setFont (wxFont& newFont) {
  this->specialLineEnd=common::specialLineEnd(newFont.GetEncoding());
  if (this->localfont != 0) {
    if (Hauptfenster::getPtr()->getLessonController() != 0 &&
	this->localfont->GetEncoding() != newFont.GetEncoding()) {
      fillFromCache();
      updateHighlightPos();
    }
    delete this->localfont;
  }
  this->localfont = new wxFont(newFont);
  updateLook();
}

void TtOutputControl::Clear() {
  Freeze();
  wxTextCtrl::Clear();
  Thaw();
}

void TtOutputControl::highlightFirstChar () {
  this->highlightCharPos = 0;
  highlightChar();
}

void TtOutputControl::highlightNextChar (unsigned int i, bool newline) {
  if (newline && this->specialLineEnd != 0) {
    this->highlightCharPos += i+1;
  } else {
    this->highlightCharPos += i;
  }
  highlightChar();  
}

#include <algorithm>
#ifndef __VISUALC__
  using std::min;
#endif
void TtOutputControl::highlightChar () {
  if (highlightCharPos >= 0) {
    LessonController* l = Hauptfenster::getPtr()->getLessonController();
    size_t diffPos = this->highlightCharPos;
    if (l != NULL &&
	l->runningLesson()) {
      // how many characters to advance in window scrolling
      size_t lineLen = l->getLesson()->getCurrentLineLen();
      size_t linePos = l->getLesson()->getCurrentLinePos();
      diffPos = min(size_t(5),lineLen);
      if (linePos < diffPos) {
	diffPos = this->highlightCharPos;
      } else {
	if (linePos+diffPos <= lineLen) {
	  diffPos += this->highlightCharPos;
	} else {
	  diffPos = this->highlightCharPos - linePos + lineLen;
	}
      }
    }
    Freeze();
    ShowPosition(diffPos); //enough for wxGTK
    SetInsertionPoint(diffPos+1); //needed for wxMSW
    Thaw();
    SetSelection(this->highlightCharPos,this->highlightCharPos+1);
  }
}

void TtOutputControl::SetSelection (long from, long to) {
  //own approach that may work but it tends to be _very_ slow :-(
  //it may be limited to wx-2.5.x and later
//   static long oldfrom = 0;
//   static long oldto = 0;
//   wxTextAttr attribs(*(this->textcolor),
// 		     *(this->bgcolor),
// 		     *(this->localfont));
//   Freeze();
//   if (from != 0) SetStyle(oldfrom,oldto,attribs);
//   attribs.SetBackgroundColour(*wxGREEN);
//   SetStyle(from,to,attribs);
//   Thaw();
//   oldfrom = from;
//   oldto = to;
  //this is not always correctly implemeted
  wxTextCtrl::SetSelection(from,to);
}

void TtOutputControl::updateHighlightPos () {
  LessonController* l = Hauptfenster::getPtr()->getLessonController();
  if (l != NULL && l->runningLesson()) {
    this->highlightCharPos = l->getLesson()->getCurrentPos();
  }  
}

void TtOutputControl::fillFromCache () {
  LessonController* l = Hauptfenster::getPtr()->getLessonController();
  if (l != NULL && l->runningLesson()) {
    l->getLesson()->outputFromCache(this,this->specialLineEnd);
  }
}
