/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <wx/datetime.h>
#include "KLessonStatusSizer.H"
#include "ConfigFile.H"

KLessonStatusSizer::KLessonStatusSizer (wxWindow* parent) 
  : wxFlexGridSizer(2,5,5)
{
  wxString temp;
  temp << _("Correct") << _T(":");
  correctText = new wxStaticText(parent,-1,temp);
  temp.Empty();
  temp << _("Mistakes") << _T(":");
  wrongText = new wxStaticText(parent,-1,temp);
  temp.Empty();
  temp << _("Touches") << _T(":");
  touchesText = new wxStaticText(parent,-1,temp);
  temp.Empty();
  temp << _("Mistakes\n(per mil)") << _T(":");
  rateText = new wxStaticText(parent,-1,temp);
  temp.Empty();
  temp << _("used time") << _T(":");
  timeText = new wxStaticText(parent,-1,temp);
  temp.Empty();
  temp << _("Touches per minute") << _T(":");
  tpmText = new wxStaticText(parent,-1,temp);
  correctField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
				wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  wrongField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
			      wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  touchesField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
				wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  rateField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
			     wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  reqrateField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
				wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  timeField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
			     wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  reqtimeField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
				wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  tpmField = new wxTextCtrl(parent,-1,_T(""),wxDefaultPosition,
			    wxDefaultSize,wxTE_READONLY|wxTE_RIGHT);
  Add(correctText,0,wxALIGN_CENTRE_VERTICAL);
  Add(correctField,0,wxALIGN_LEFT);
  Add(wrongText,0,wxALIGN_CENTRE_VERTICAL);
  Add(wrongField,0,wxALIGN_LEFT);
  Add(touchesText,0,wxALIGN_CENTRE_VERTICAL);
  Add(touchesField,0,wxALIGN_LEFT);
  Add(rateText,0,wxALIGN_CENTRE_VERTICAL);
  rateSizer = new wxBoxSizer (wxHORIZONTAL);
  rateSizer->Add(rateField);
  rateSizer->Add(reqrateField);
  Add(rateSizer,0,wxALIGN_LEFT);
  Add(timeText,0,wxALIGN_CENTRE_VERTICAL);
  timeSizer = new wxBoxSizer (wxHORIZONTAL);
  timeSizer->Add(timeField,0,wxALIGN_LEFT);
  timeSizer->Add(reqtimeField,0,wxALIGN_LEFT);
  Add(timeSizer,0,wxALIGN_LEFT);
  Add(tpmText,0,wxALIGN_CENTRE_VERTICAL);
  Add(tpmField,0,wxALIGN_LEFT);
}

void KLessonStatusSizer::setStatus (const LEntry& status, const LKrit& crit) {
  wxString temp;
  temp << status.getAnschlaege();
  this->touchesField->SetValue(temp);

  temp.Empty();
  temp.Printf(_T("%.f"),status.getApM());
  this->tpmField->SetValue(temp);

  temp.Empty();
  temp << status.getRichtig();
  this->correctField->SetValue(temp);

  temp.Empty();
  temp << status.getFehler();
  this->wrongField->SetValue(temp);

  temp.Empty();
  temp.Printf(_T("%.f"), status.getPromille());
  this->rateField->SetValue(temp);
  if (crit.getPromille() > 0) {
    this->reqrateField->Show(true);
    temp.Empty();
    temp << crit.getPromille();
    this->reqrateField->SetValue(temp);
  } else {
    this->reqrateField->Show(false);
  }
  this->rateSizer->Layout();

  if (status.getZeit() >= 0) {
    this->timeField->SetValue(status.getZeitString());
  }
  if (crit.getZeit() > 0) {
    this->reqtimeField->Show(true);
    this->reqtimeField->SetValue(crit.getZeitString());
  } else {
    this->reqtimeField->Show(false);
  }
  this->timeSizer->Layout();
  this->Layout();
}
