/***************************************************************************
                          lektionsauswertung.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Feb  1 21:30:22 MET 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "lektionsauswertung.h"

#include "wx/sizer.h"
#include "wx/statline.h"
#include "wx/image.h"


//*********************************************************************
//*********************************************************************
//* Objekt fr Lektionsauswertung
//*********************************************************************
//*********************************************************************


BEGIN_EVENT_TABLE(lauswertung, wxDialog)
  
END_EVENT_TABLE()
//*********************************************************************
//* Konstruktor
//*********************************************************************

lauswertung::lauswertung(wxWindow *parent, const wxString& title, Lektion* lektion)
  : wxDialog(parent, -1, title, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE , "Lektionsauswertung")
{
  SetAutoLayout(TRUE);

   wxBoxSizer *topsizer = new wxBoxSizer( wxVERTICAL );
  wxBoxSizer *icon_text = new wxBoxSizer( wxHORIZONTAL );

#ifdef __WXMSW__
  wxBitmap::AddHandler(new wxPNGFileHandler);
#endif
#ifdef __WXGTK__
  wxImage::AddHandler(new wxPNGHandler);
#endif

   wxString f;
  f << L_DIR << "logo.png";
  wxBitmap logo(f, wxBITMAP_TYPE_PNG);
   wxStaticBitmap *icon = new wxStaticBitmap(this, -1, logo);
  icon_text->Add( icon, 0, wxCENTER );
  //icon_text->Add(CreateTextSizer("Hier soll ein Icon hin"), 0, wxCENTER);

   wxString msg;
  msg << _("Lektionsauswertung\n")
      << "---------------\n\n"
      << _("Anschlge:                                 ")<< lektion->GetAnschlaege() << "\n\n"
      << _("Fehler:                                        ")  << lektion->GetFehler() << "\n\n"
      << _("Fehler in Promille:                       ")  << lektion->GetFP() << " \n\n"
      << _("Richtig:                                        ")  << lektion->GetRichtig() << "\n\n"
      << _("Anschlge pro Minute:               ") << lektion->GetApM() << "\n\n";
     
  icon_text->Add(CreateTextSizer(msg), 0, wxCENTER | wxLEFT, 10);

  topsizer->Add(icon_text, 0, wxLEFT | wxRIGHT | wxTOP, 10);
  topsizer->Add( new wxStaticLine( this, -1 ), 0, wxEXPAND | wxLEFT|wxRIGHT|wxTOP, 10 );
   topsizer->Add( CreateButtonSizer(wxOK), 0, wxCENTRE | wxALL, 10 );
  topsizer->Fit(this);
  SetSizer(topsizer);
  Center();

  
}

//********************************************************************
//* Fenster Schlieen
//********************************************************************

void lauswertung::OnSchliessen(wxCommandEvent* event)
{
  EndModal(GetReturnCode());
}
