/***************************************************************************
                          kladen.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Jun  9 20:38:36 MEST 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <wx/config.h>

#include "kladen.h"


//**************************************************
//*
//*           Event Table fr KLDialog
//*
//**************************************************

enum
{
  mOK = 23,
  mCancel = 24,
  mLB = 25
};

BEGIN_EVENT_TABLE(KLDialog, wxDialog)
  EVT_BUTTON(mOK, KLDialog::OnOK)
  EVT_BUTTON(mCancel, KLDialog::OnCancel)
  EVT_LISTBOX(mLB, KLDialog::OnListBox)
  EVT_LISTBOX_DCLICK(mLB, KLDialog::OnOK)
END_EVENT_TABLE()

//**************************************************
//* Konstruktor
//**************************************************

KLDialog::KLDialog(wxWindow *parent)
    :wxDialog(parent, -1, _("Kurs laden"), wxDefaultPosition, wxSize(410, 200), wxDEFAULT_DIALOG_STYLE, _("Kurs laden"))
{
  m_lb = new wxListBox(this, mLB, wxPoint(5,5), wxSize(200, 190));
  m_OK = new wxButton(this, mOK, _("Kurs laden"), wxPoint(220, 46), wxSize(180, 35));
  //m_OK->Enable(FALSE);
  m_Cancel = new wxButton(this, mCancel, _("Abbrechen"), wxPoint(220, 113), wxSize(180, 35));
  Center();
  // gespeicherten Kurse einlesen
  wxConfigBase *pConfig = wxConfigBase::Get();
  wxString key;
  key << "Kurs";
  //  pConfig->SetPath("/Kurs");
  long l=0;
  wxString s;
  pConfig->SetPath("/Kurs");
  m_entries.Clear();
  while (pConfig->GetNextGroup(s, l))
    {
      m_entries.Add(s);
      m_lb->Append(s.BeforeLast('_'));
    }
}

void KLDialog::OnOK(wxCommandEvent* event)
{
 if(m_lb->GetSelection() > -1)
   EndModal(m_lb->GetSelection());
}

void KLDialog::OnCancel(wxCommandEvent* event)
{
  EndModal(-1);
}

void KLDialog::OnListBox(wxCommandEvent* event)
{
  if (m_lb->GetSelection()!=-1)
    m_OK->Enable(TRUE);
}


wxString KLDialog::GetSelection()
{
  return m_entries[(m_lb->GetSelection())];
}

