/***************************************************************************
                          auswahl.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Apr 30 14:49:16 MEST 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "auswahl.h"
#include "info.h"
#include <wx/image.h>

BEGIN_EVENT_TABLE(Auswahldialog, wxDialog)
  EVT_BUTTON(LL, Auswahldialog::OnLL)
  EVT_BUTTON(KL, Auswahldialog::OnKL)
  EVT_BUTTON(KB, Auswahldialog::OnKB)
END_EVENT_TABLE()
  
//**********************************************
//* Konstruktor
//**********************************************

Auswahldialog::Auswahldialog(wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos = wxDefaultPosition, 
const wxSize& size =wxDefaultSize, long style = wxDEFAULT_DIALOG_STYLE, const wxString& name = "dialogBox") : wxDialog(parent, id, title, pos, size, style, name)
{
  SetAutoLayout(TRUE);
#ifdef __WXMSW__
  wxBitmap::AddHandler(new wxPNGFileHandler);
#endif
#ifdef __WXGTK__
  wxImage::AddHandler(new wxPNGHandler);
#endif
   wxString f;
  f << L_DIR << "logo.png";
  wxBitmap* logo = new wxBitmap(f , wxBITMAP_TYPE_PNG);

  MyCanvas* canvas = new MyCanvas(this,  logo, wxDefaultPosition, wxDefaultSize);
   wxLayoutConstraints *c1 = new wxLayoutConstraints;
  c1->top.SameAs(this, wxTop, 2);
  c1->left.SameAs(this, wxLeft, 2);
  c1->width.PercentOf(this, wxWidth, 52);
  c1->height.PercentOf(this, wxHeight, 95);
  canvas->SetConstraints(c1);

  m_KB = new wxButton(this, KB, _("Kurs &beginnen..."));
  wxLayoutConstraints *c2 = new wxLayoutConstraints;
  c2->top.SameAs(this, wxTop, 40);
  c2->left.SameAs(canvas, wxRight, 10);
  c2->width.PercentOf(this, wxWidth, 40);
  c2->height.PercentOf(this, wxHeight, 15);
  m_KB->SetConstraints(c2);
  
  m_KL = new wxButton(this, KL, _("&Kurs laden..."));
  wxLayoutConstraints *c3 = new wxLayoutConstraints;
  c3->top.SameAs(m_KB, wxBottom, 15);
  c3->left.SameAs(canvas, wxRight, 10);
  c3->width.PercentOf(this, wxWidth, 40);
  c3->height.PercentOf(this, wxHeight, 15); 
  m_KL->SetConstraints(c3);
  
  m_LL = new wxButton(this, LL, _("Lektion &laden..."));
  wxLayoutConstraints *c4 = new wxLayoutConstraints;
  c4->top.SameAs(m_KL, wxBottom, 15);
  c4->left.SameAs(canvas, wxRight, 10);
  c4->width.PercentOf(this, wxWidth, 40);
  c4->height.PercentOf(this, wxHeight, 15);
  m_LL->SetConstraints(c4);

}

Auswahldialog::~Auswahldialog()
{
  
}

void Auswahldialog::OnLL(wxCommandEvent* event)
{
  EndModal(LL);
}

void Auswahldialog::OnKL(wxCommandEvent* event)
{
  EndModal(KL);
}

void Auswahldialog::OnKB(wxCommandEvent* event)
{
  EndModal(KB);
}
