#ifndef INDII_TINT_GUI_PREVIEWPANE_HPP
#define INDII_TINT_GUI_PREVIEWPANE_HPP

#include "TintPane.hpp"
#include "PreviewImage.hpp"
#include "../ImageResource.hpp"
#include "../ClusterModel.hpp"

#include "wx/panel.h"

namespace indii {
  namespace tint {
    namespace gui {
/**
 * Preview pane.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 74 $
 * @date $Date: 2009-03-02 14:59:56 +0900 (Mon, 02 Mar 2009) $
 */
class PreviewPane : public wxPanel {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param res Image resource.
   * @param model Cluster model.
   */
  PreviewPane(wxWindow* parent, ImageResource* res, ClusterModel* model);

  /**
   * Get preview image.
   */
  PreviewImage* getPreviewImage();
  
private:
  /**
   * Image resources.
   */
  ImageResource* res;

  /**
   * Cluster model.
   */
  ClusterModel* model;

  /**
   * Preview image.
   */
  PreviewImage* preview;

};

    }
  }
}

inline indii::tint::gui::PreviewImage*
    indii::tint::gui::PreviewPane::getPreviewImage() {
  return preview;
}

#endif

