#ifndef INDII_TINT_OBSERVABLE_HPP
#define INDII_TINT_OBSERVABLE_HPP

#include "Observer.hpp"

#include <set>

namespace indii {
  namespace tint {

/**
 * Abstract observable object.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 74 $
 * @date $Date: 2009-03-02 14:59:56 +0900 (Mon, 02 Mar 2009) $
 *
 * @param T Type of observer.
 */
template<class T>
class Observable {
public:
  /**
   * Destructor.
   */
  virtual ~Observable();

  /**
   * Registry type.
   */
  typedef std::set<Observer<T>*> registry_t;

  /**
   * Register observer.
   */
  void subscribe(Observer<T>* o);

  /**
   * Deregister observer.
   */
  void unsubscribe(Observer<T>* o);

  /**
   * Notify all registered observers of change.
   */
  void notifyAll();
  
  /**
   * Notify all registered observers of destruction.
   */
  void notifyDestroy();
   
protected:
  /**
   * Registry of observers.
   */
  registry_t os;
  
};

  }
}

template <class T>
indii::tint::Observable<T>::~Observable() {
  notifyDestroy();
}

template <class T>
void indii::tint::Observable<T>::subscribe(Observer<T>* o) {
  os.insert(o);
}

template <class T>
void indii::tint::Observable<T>::unsubscribe(Observer<T>* o) {
  os.erase(o);
}

template <class T>
void indii::tint::Observable<T>::notifyAll() {
  typename registry_t::iterator iter;
  for (iter = os.begin(); iter != os.end(); iter++) {
    (*iter)->notify();
  }
}

template <class T>
void indii::tint::Observable<T>::notifyDestroy() {
  typename registry_t::iterator iter;
  for (iter = os.begin(); iter != os.end(); iter++) {
    (*iter)->notifyDestroy();
  }
}

#endif

