#include "MaskCache.hpp"

using namespace indii::tint;

MaskCache::MaskCache(wxImage* image) : original(image) {
  originalMask = new wxBitmap(*image);
}

MaskCache::~MaskCache() {
  cache_t::iterator iter;
  for (iter = cache.begin(); iter != cache.end(); iter++) {
    delete iter->second;
  }
  delete originalMask;
}

wxMask* MaskCache::get(const int width, const int height) {
  wxBitmap* mask;
  
  if ((width == original->GetWidth() && height == original->GetHeight()) ||
      width <= 0 || height <= 0) {
    /* no need to resize, return original */
    mask = originalMask;
  } else {
    dim_t dim(width, height);  
    cache_t::iterator find = cache.find(dim);
    if (find != cache.end()) {
      mask = find->second;
    } else {
      mask = new wxBitmap(original->Scale(width, height));
      cache.insert(cache_pair_t(dim, mask));
    }
  }

  return new wxMask(*mask, *wxBLACK);
}

