#ifndef INDII_TINT_FILEIMAGERESOURCE_HPP
#define INDII_TINT_FILEIMAGERESOURCE_HPP

#include "ImageResource.hpp"
#include "ImageCache.hpp"

namespace indii {
  namespace tint {

/**
 * File based image resource manager.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 74 $
 * @date $Date: 2009-03-02 14:59:56 +0900 (Mon, 02 Mar 2009) $
 */
class FileImageResource : public ImageResource {
public:
  /**
   * Constructor.
   *
   * @param path Path name of the image.
   */
  FileImageResource(const wxString& path);

  /**
   * Destructor.
   */
  virtual ~FileImageResource();

  virtual unsigned int getWidth();
  
  virtual unsigned int getHeight();
  
  virtual wxImage* get(const int width = 0, const int height = 0,
      const bool high = false);

  virtual wxImage calc(const wxRect& rect, const unsigned int width = 0,
      const unsigned int height = 0, const bool high = false);

private:
  /**
   * Original image.
   */
  wxImage* original;
  
  /**
   * Resized image cache.
   */
  ImageCache* lowCache;
  
  /**
   * Resized image cache, high quality.
   */
  ImageCache* highCache;

};

  }
}

inline unsigned int indii::tint::FileImageResource::getWidth() {
  return original->GetWidth();
}

inline unsigned int indii::tint::FileImageResource::getHeight() {
  return original->GetHeight();
}

inline wxImage* indii::tint::FileImageResource::get(const int width,
    const int height, const bool high) {
  if (high) {
    return highCache->get(width, height);
  } else {
    return lowCache->get(width, height);
  }
}

inline wxImage indii::tint::FileImageResource::calc(const wxRect& rect,
    const unsigned int width, const unsigned int height, const bool high) {
  return get(width, height, high)->GetSubImage(rect);
}

#endif
