#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#define ELMALIAS "/usr/bin/elmalias "

void expand_aliases ( char* what, char* line )
{
	char *alias;
	char *delim;
	FILE *pipe_fp;
	char cmd[512];
	int  first=1;

	printf("%s",what);
	alias=(char *)strtok(line," ,");
	while (alias) {
		alias=(char *)strtok(NULL," ,");
		if (alias) {
			strcpy(cmd,ELMALIAS);
			strcat(cmd,alias);
			if ( (pipe_fp=popen(cmd,"r")) == NULL ) {
				fprintf(stderr,"couldn't execute %s\n", cmd);
				printf("%s",line);
			} else {
				while ( fgets(cmd,512,pipe_fp) ) {
					if ( (delim=(char *)strchr(cmd,'\n')) )
						*delim=(char)0;
					if ( ! first )
						printf("%c",',');
					printf("%s",cmd);
				}
				fclose(pipe_fp);
				first=0;
			}
		}
	}
	printf("\n");
}

int main ( int argc, char* argv[] )
{
	FILE *f;
	char line[512];
	char *file;
	int copy_mode=0;

	if ( argc > 2 ) {
		fprintf(stderr,"usage: expand_alias file\n");
		exit(1);
	}
	if ( argc == 1 || ! strcmp (argv[1],"-") ) {
		f=stdin;
	}
	else {
		file=(char *)strdup(argv[1]);
		if ( access(file,R_OK) ) {
			fprintf(stderr,"couldn't access %s\n",file);
			exit(1);
		}
		if ( !( f=fopen(file,"r")) ) {
			fprintf(stderr,"couldn't open %s\n",file);	
			exit(1);
		}
	}
	while ( fgets(line,sizeof(line),f) ) {
		if (copy_mode)
			printf("%s",line);
		else {
			if ( ! strncasecmp ( line , "To: " , 4 ) )
				expand_aliases("To: ",line);
			else if ( ! strncasecmp ( line , "Cc: " , 4 ) )
				expand_aliases("Cc: ",line);
			else if ( ! strncasecmp ( line , "Bcc: " , 5 ) )
				expand_aliases("Bcc: ",line);
			else
				printf("%s",line);
			copy_mode = ! strcmp ( line , "\n" );
		}
	}
	return 0;
}
