/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2001 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef ___AUDRIV_H_
#define ___AUDRIV_H_

#ifndef Bool
#define Bool int
#endif

#ifndef False
#define False 0
#endif

#ifndef True
#define True 1
#endif

extern char audriv_errmsg[BUFSIZ];
/* 顼ȯϡ顼åꤵޤ
 * ưƤϡѹޤ
 */

/* ǥ򼨤 */
enum audriv_ports
{
    AUDRIV_OUTPUT_SPEAKER,
    AUDRIV_OUTPUT_HEADPHONE,
    AUDRIV_OUTPUT_LINE_OUT
};


extern Bool audriv_setup_audio(void);
/* ǥνԤޤ
 *  True 򡤼Ԥ False ֤ޤ
 */

extern void audriv_free_audio(void);
/* audio θԤޤ
 */

extern Bool audriv_play_open(void);
/* audio Ѥ˳ĤǤ audriv_write() ˤղǽ
 * ֤ˤޤ˳ƤϤʤˤԤޤ
 *  True 򡤼Ԥ False ֤ޤ
 */

extern void audriv_play_close(void);
/* Ѥ˥ץ󤵤줿 audio ĤޤǤĤƤ
 * ϤʤˤԤޤ
 */

extern long audriv_play_stop(void);
/* դ¨¤ߤľΥץ֤ޤ
 * audriv_play_stop() θƤӽФˤäơaudio Ĥޤ
 * audio ĤƤ audriv_play_stop() ƤӽФ 0 
 * ֤ޤ
 * 顼ξ -1 ֤ޤ
 */

extern Bool audriv_is_play_open(void);
/* audio դǥץ󤵤Ƥ True,
 * ĤƤ False ֤ޤ
 */

extern Bool audriv_set_play_volume(int volume);
/* ղ̤ 0  255 ϰꤷޤ0 ̵255 Ϻ粻̡
 * 0 ̤ 0255 Ķͤ 255 
 *  True 򡤼Ԥ False ֤ޤ
 */

extern int audriv_get_play_volume(void);
/* ղ̤ 0  255 ޤ0 ̵255 Ϻ粻̡
 * Ԥ -1 ֤Ǥʤ 0  255 β̤֤ޤ
 */

extern Bool audriv_set_play_output(int port);
/* audio ν port ꤷޤport ˤϰʲΤɤ줫ꤷޤ
 *
 *     AUDRIV_OUTPUT_SPEAKER	ԡ˽ϡ
 *     AUDRIV_OUTPUT_HEADPHONE	إåɥۥ˽ϡ
 *     AUDRIV_OUTPUT_LINE_OUT	饤󥢥Ȥ˽ϡ
 *
 *  True 򡤼Ԥ False ֤ޤ
 */

extern int audriv_get_play_output(void);
/* audio ν port ޤ
 * Ԥ -1 ֤ȰʲΤ줫֤ͤޤ
 *
 *     AUDRIV_OUTPUT_SPEAKER	ԡ˽ϡ
 *     AUDRIV_OUTPUT_HEADPHONE	إåɥۥ˽ϡ
 *     AUDRIV_OUTPUT_LINE_OUT	饤󥢥Ȥ˽ϡ
 *
 */

extern int audriv_write(char *buff, int n);
/* audio  buff  n Хʬήߤޤ
 * audriv_set_noblock_write() ֥å⡼ɤꤵ줿
 * ϡδؿθƤӽФ¨¤˽֤ޤ
 * ֤ͤϼºݤήޤ줿ХȿǤꡤ֥å⡼ɤ
 * Ƥϡ n 꾯ʤ礬ޤ
 * Ԥ -1 ֤ȡºݤήޤ줿Хȿ֤ޤ
 */

extern Bool audriv_set_noblock_write(Bool noblock);
/* noblock  True ꤹȡaudriv_write() ƤӽФǥ֥åޤ
 * False ꤹȡǥեȤξ֤ᤷޤ
 *  True 򡤼Ԥ False ֤ޤ
 */

extern int audriv_play_active(void);
/* ʤ 1Ǥʤʤ 0, 顼ʤ -1 ֤ޤ
 */

extern long audriv_play_samples(void);
/* ߱Υץ֤֤ޤ
 */

extern long audriv_get_filled(void);
/* ǥХåեΥХȿ֤ޤ
 * 顼ξ -1 ֤ޤ
 */

extern const long *audriv_available_encodings(int *n_ret);
/* ޥ󤬥ݡȤƤ뤹٤Ƥ沽ꥹȤ֤ޤn_ret ˤ
 * μο֤ޤ沽򤢤魯ͤ
 * aenc.h ƤͤǤ
 * ֤ͤ free ƤϤʤޤ
 */

extern const long *audriv_available_sample_rates(int *n_ret);
/* ޥ󤬥ݡȤƤ뤹٤ƤΥץ졼ȤΥꥹȤ֤ޤ
 * ֤ͤΥץ졼Ȥ㤤ˤʤǤޤ
 * n_ret ˤϤμο֤ޤ
 * ֤ͤ free ƤϤʤޤ
 */

extern const long *audriv_available_channels(int *n_ret);
/* ޥ󤬥ݡȤƤ뤹٤ƤΥͥΥꥹȤ֤ޤ
 * n_ret ˤϤμο֤ޤ
 * ֤ͤ free ƤϤʤޤ
 */

extern Bool audriv_set_play_encoding(long encoding);
/* audio ջ沽ꤷޤ
 *  True 򡤼Ԥ False ֤ޤ
 */

extern Bool audriv_set_play_sample_rate(long sample_rate);
/* audio ջΥץ졼Ȥꤷޤ
 *  True 򡤼Ԥ False ֤ޤ
 */

extern Bool audriv_set_play_channels(long channels);
/* ѤΥͥꤷޤ
 * Ԥ False ֤ True ֤ޤ
 */

extern void (* audriv_error_handler)(const char *errmsg);
/* NULL ǤʤС顼ȯƤӽФޤ
 */

extern void audriv_wait_play(void);
/* CPU ѥϲ񤷤ʤ褦ˤ뤿ˡŪߤޤ*/

#endif /* ___AUDRIV_H_ */
